/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIdListToCommaDelimitedQueryParam
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Iterable), (Object)"this binder is only valid for Iterables!");
        Iterable numbers = (Iterable)Preconditions.checkNotNull((Object)input, (Object)"list of Longs");
        Preconditions.checkArgument((!Iterables.isEmpty((Iterable)numbers) ? 1 : 0) != 0, (Object)"you must specify at least one element");
        return (R)request.toBuilder().replaceQueryParam("ids", new String[]{Joiner.on((char)',').join(numbers)}).build();
    }
}

