/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mariadb;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.database.mariadb.MariaDbDriver;
import org.apache.brooklyn.entity.database.mariadb.MariaDbNode;
import org.apache.brooklyn.entity.database.mariadb.MariaDbNodeImpl;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbSshDriver
extends AbstractSoftwareProcessSshDriver
implements MariaDbDriver {
    public static final Logger log = LoggerFactory.getLogger(MariaDbSshDriver.class);

    public MariaDbSshDriver(MariaDbNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
        entity.sensors().set(Attributes.LOG_FILE_LOCATION, (Object)this.getLogFile());
    }

    public String getOsTag() {
        OsDetails os = this.getLocation().getOsDetails();
        if (os == null) {
            return "linux-i686";
        }
        if (os.isWindows() || os.isMac()) {
            throw new UnsupportedOperationException("only support linux versions just now; OS details: " + os);
        }
        return os.is64bit() ? "linux-x86_64" : "linux-i686";
    }

    public String getDownloadParentDir() {
        OsDetails os = this.getLocation().getOsDetails();
        if (os == null) {
            return "bintar-linux-x86";
        }
        if (os.isWindows() || os.isMac()) {
            throw new UnsupportedOperationException("only support linux versions just now; OS details: " + os);
        }
        return os.is64bit() ? "bintar-linux-x86_64" : "bintar-linux-x86";
    }

    public String getMirrorUrl() {
        return (String)this.entity.getConfig(MariaDbNode.MIRROR_URL);
    }

    public String getBaseDir() {
        return this.getExpandedInstallDir();
    }

    public String getDataDir() {
        String result = (String)this.entity.getConfig(MariaDbNode.DATA_DIR);
        return result == null ? "." : result;
    }

    public String getLogFile() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), "console.log"});
    }

    public String getConfigFile() {
        return "my.cnf";
    }

    public String getInstallFilename() {
        return String.format("mariadb-%s-%s.tar.gz", this.getVersion(), this.getOsTag());
    }

    public void prepare() {
        this.resolver = Entities.newDownloader((EntityDriver)this, (Map)ImmutableMap.of((Object)"filename", (Object)this.getInstallFilename()));
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("mariadb-%s-%s", this.getVersion(), this.getOsTag()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(BashCommands.INSTALL_TAR);
        commands.add(BashCommands.INSTALL_CURL);
        commands.add("echo installing extra packages");
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libgcc_s.so.1"), null));
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libaio.so.1 libncurses.so.5", (Object)"apt", (Object)"libaio1 libaio-dev"), null));
        commands.add(BashCommands.ok((String)BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libaio", (Object)"apt", (Object)"ia32-libs"), null)));
        commands.add("echo finished installing extra packages");
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(String.format("tar xfvz %s", saveAs));
        this.newScript((String)"installing").body.append(commands).execute();
    }

    public MariaDbNodeImpl getEntity() {
        return (MariaDbNodeImpl)super.getEntity();
    }

    public int getPort() {
        return this.getEntity().getPort();
    }

    public String getSocketUid() {
        return this.getEntity().getSocketUid();
    }

    public String getPassword() {
        return this.getEntity().getPassword();
    }

    public void customize() {
        this.copyDatabaseConfigScript();
        this.newScript((String)"customizing").updateTaskAndFailOnNonZeroResultCode().body.append(new CharSequence[]{"chmod 600 " + this.getConfigFile(), this.getBaseDir() + "/scripts/mysql_install_db --basedir=" + this.getBaseDir() + " --datadir=" + this.getDataDir() + " --defaults-file=" + this.getConfigFile()}).execute();
        this.launch();
        CountdownTimer timer = Duration.seconds((Number)20).countdownTimer();
        boolean hasCreationScript = this.copyDatabaseCreationScript();
        timer.waitForExpiryUnchecked();
        DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), this.getBaseDir() + "/bin/mysqladmin --defaults-file=" + this.getConfigFile() + " --password= password " + this.getPassword()}).summary("setting password"));
        if (hasCreationScript) {
            this.executeScriptFromInstalledFileAsync("creation-script.sql");
        }
        this.stop();
    }

    private void copyDatabaseConfigScript() {
        this.newScript("customizing").execute();
        String configScriptContents = this.processTemplate((String)this.entity.getAttribute(MariaDbNode.TEMPLATE_CONFIGURATION_URL));
        StringReader configContents = new StringReader(configScriptContents);
        this.getMachine().copyTo((Reader)configContents, Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getConfigFile()}));
    }

    private boolean copyDatabaseCreationScript() {
        InputStream creationScript = DatastoreMixins.getDatabaseCreationScript((Entity)this.entity);
        if (creationScript == null) {
            return false;
        }
        this.getMachine().copyTo(creationScript, this.getRunDir() + "/creation-script.sql");
        return true;
    }

    public String getMariaDbServerOptionsString() {
        Map options = (Map)this.entity.getConfig(MariaDbNode.MARIADB_SERVER_CONF);
        StringBuilder result = new StringBuilder();
        if (JavaGroovyEquivalents.groovyTruth((Object)options)) {
            for (Map.Entry entry : options.entrySet()) {
                result.append((String)entry.getKey());
                String value = entry.getValue().toString();
                if (!Strings.isEmpty((CharSequence)value)) {
                    result.append(" = ").append(value);
                }
                result.append('\n');
            }
        }
        return result.toString();
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)String.format("nohup %s/bin/mysqld --defaults-file=%s --user=`whoami` > %s 2>&1 < /dev/null &", this.getBaseDir(), this.getConfigFile(), this.getLogFile())).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)this.getStatusCmd()).execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    public void kill() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "killing").execute();
    }

    @Override
    public String getStatusCmd() {
        return String.format("%s/bin/mysqladmin --defaults-file=%s status", this.getExpandedInstallDir(), Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getConfigFile()}));
    }

    @Override
    public ProcessTaskWrapper<Integer> executeScriptAsync(String commands) {
        String filename = "mariadb-commands-" + Identifiers.makeRandomId((int)8);
        DynamicTasks.queue((TaskFactory)SshEffectorTasks.put((String)Urls.mergePaths((String[])new String[]{this.getRunDir(), filename})).contents(commands).summary("copying datastore script to execute " + filename));
        return this.executeScriptFromInstalledFileAsync(filename);
    }

    public ProcessTaskWrapper<Integer> executeScriptFromInstalledFileAsync(String filenameAlreadyInstalledAtServer) {
        return (ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), this.getBaseDir() + "/bin/mysql --defaults-file=" + this.getConfigFile() + " < " + filenameAlreadyInstalledAtServer}).requiringExitCodeZero()).summary("executing datastore script " + filenameAlreadyInstalledAtServer));
    }
}

