/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.jmx;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.feed.FeedConfig;
import org.apache.brooklyn.util.collections.MutableList;

public class JmxNotificationSubscriptionConfig<T>
extends FeedConfig<Notification, T, JmxNotificationSubscriptionConfig<T>> {
    private ObjectName objectName;
    private NotificationFilter notificationFilter;
    private Function<Notification, T> onNotification;

    public JmxNotificationSubscriptionConfig(AttributeSensor<T> sensor) {
        super(sensor);
        this.onSuccess(Functions.identity());
    }

    public JmxNotificationSubscriptionConfig(JmxNotificationSubscriptionConfig<T> other) {
        super(other);
        this.objectName = other.objectName;
        this.notificationFilter = other.notificationFilter;
        this.onNotification = other.onNotification;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public NotificationFilter getNotificationFilter() {
        return this.notificationFilter;
    }

    public Function<Notification, T> getOnNotification() {
        return this.onNotification;
    }

    public JmxNotificationSubscriptionConfig<T> objectName(ObjectName val) {
        this.objectName = val;
        return this;
    }

    public JmxNotificationSubscriptionConfig<T> objectName(String val) {
        try {
            return this.objectName(new ObjectName(val));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name (" + val + ")", e);
        }
    }

    public JmxNotificationSubscriptionConfig<T> notificationFilter(NotificationFilter val) {
        this.notificationFilter = val;
        return this;
    }

    public JmxNotificationSubscriptionConfig<T> onNotification(Function<Notification, T> val) {
        this.onNotification = val;
        return this;
    }

    protected Object toStringPollSource() {
        return this.objectName;
    }

    protected MutableList<Object> equalsFields() {
        return super.equalsFields().appendIfNotNull((Object)this.notificationFilter).appendIfNotNull(this.onNotification);
    }
}

