/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudfiles.v1.domain.CDNContainer;
import org.jclouds.rest.InvocationContext;

public class ParseCDNContainerFromHeaders
implements Function<HttpResponse, CDNContainer>,
InvocationContext<ParseCDNContainerFromHeaders> {
    private HttpRequest request;

    public CDNContainer apply(HttpResponse from) {
        String uri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Uri"), (Object)"X-Cdn-Uri");
        String sslUri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Ssl-Uri"), (Object)"X-Cdn-Ssl-Uri");
        String streamingUri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Streaming-Uri"), (Object)"X-Cdn-Streaming-Uri");
        String iosUri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Ios-Uri"), (Object)"X-Cdn-Ios-Uri");
        String enabled = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Enabled"), (Object)"X-Cdn-Enabled");
        String logRetention = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Log-Retention"), (Object)"X-Log-Retention");
        String ttl = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Ttl"), (Object)"X-Ttl");
        ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((char)'/').split((CharSequence)this.request.getEndpoint().getPath()));
        Preconditions.checkArgument((!parts.isEmpty() ? 1 : 0) != 0);
        return CDNContainer.builder().name((String)parts.get(parts.size() - 1)).enabled(Boolean.parseBoolean(enabled)).logRetention(Boolean.parseBoolean(logRetention)).ttl(Integer.parseInt(ttl)).uri(URI.create(uri)).sslUri(URI.create(sslUri)).streamingUri(URI.create(streamingUri)).iosUri(URI.create(iosUri)).build();
    }

    public ParseCDNContainerFromHeaders setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

