/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.openshift;

import com.google.common.collect.ImmutableSet;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.ProjectFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.openshift.client.dsl.ClientDeployableScalableResource;
import io.fabric8.openshift.client.dsl.ClientTemplateResource;
import java.net.InetAddress;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.container.entity.openshift.OpenShiftPod;
import org.apache.brooklyn.container.location.kubernetes.KubernetesClientRegistry;
import org.apache.brooklyn.container.location.kubernetes.KubernetesLocation;
import org.apache.brooklyn.container.location.kubernetes.machine.KubernetesMachineLocation;
import org.apache.brooklyn.container.location.openshift.OpenShiftLocationConfig;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.config.ResolvingConfigBag;
import org.apache.brooklyn.util.net.Networking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftLocation
extends KubernetesLocation
implements OpenShiftLocationConfig {
    public static final String OPENSHIFT_GENERATED_BY = "openshift.io/generated-by";
    private static final Logger LOG = LoggerFactory.getLogger(OpenShiftLocation.class);
    private OpenShiftClient client;

    public OpenShiftLocation() {
    }

    public OpenShiftLocation(Map<?, ?> properties) {
        super(properties);
    }

    @Override
    protected KubernetesClient getClient(ConfigBag config) {
        if (this.client == null) {
            KubernetesClientRegistry registry = (KubernetesClientRegistry)this.getConfig(OPENSHIFT_CLIENT_REGISTRY);
            this.client = (OpenShiftClient)registry.getKubernetesClient(ResolvingConfigBag.newInstanceExtending((ManagementContext)this.getManagementContext(), (ConfigBag)config));
        }
        return this.client;
    }

    @Override
    protected boolean handleResourceDelete(String resourceType, String resourceName, String namespace) {
        if (super.handleResourceDelete(resourceType, resourceName, namespace)) {
            return true;
        }
        try {
            switch (resourceType) {
                case "DeploymentConfig": {
                    return (Boolean)((ClientDeployableScalableResource)((ClientNonNamespaceOperation)this.client.deploymentConfigs().inNamespace(namespace)).withName(resourceName)).delete();
                }
                case "Project": {
                    return (Boolean)((ClientResource)this.client.projects().withName(resourceName)).delete();
                }
                case "Template": {
                    return (Boolean)((ClientTemplateResource)((ClientNonNamespaceOperation)this.client.templates().inNamespace(namespace)).withName(resourceName)).delete();
                }
                case "BuildConfig": {
                    return (Boolean)((ClientBuildConfigResource)((ClientNonNamespaceOperation)this.client.buildConfigs().inNamespace(namespace)).withName(resourceName)).delete();
                }
            }
        }
        catch (KubernetesClientException kce) {
            LOG.warn("Error deleting resource {}: {}", (Object)resourceName, (Object)kce);
        }
        return false;
    }

    @Override
    protected boolean findResourceAddress(LocationSpec<? extends KubernetesMachineLocation> locationSpec, Entity entity, HasMetadata metadata, String resourceType, String resourceName, String namespace) {
        if (super.findResourceAddress(locationSpec, entity, metadata, resourceType, resourceName, namespace)) {
            return true;
        }
        if (resourceType.equals("DeploymentConfig")) {
            DeploymentConfig deploymentConfig = (DeploymentConfig)metadata;
            Map labels = deploymentConfig.getSpec().getTemplate().getMetadata().getLabels();
            Pod pod = this.getPod(namespace, labels);
            entity.sensors().set(OpenShiftPod.KUBERNETES_POD, (Object)pod.getMetadata().getName());
            InetAddress node = Networking.getInetAddressWithFixedName((String)pod.getSpec().getNodeName());
            String podAddress = pod.getStatus().getPodIP();
            locationSpec.configure((CharSequence)"address", (Object)node);
            locationSpec.configure(SshMachineLocation.PRIVATE_ADDRESSES, (Object)ImmutableSet.of((Object)podAddress));
            return true;
        }
        return false;
    }

    @Override
    protected synchronized Namespace createOrGetNamespace(final String name, Boolean create) {
        Project project = (Project)((ClientResource)this.client.projects().withName(name)).get();
        KubernetesLocation.ExitCondition projectReady = new KubernetesLocation.ExitCondition(){

            @Override
            public Boolean call() {
                Project actualProject = (Project)((ClientResource)OpenShiftLocation.this.client.projects().withName(name)).get();
                return actualProject != null && actualProject.getStatus().getPhase().equals("Active");
            }

            @Override
            public String getFailureMessage() {
                Project actualProject = (Project)((ClientResource)OpenShiftLocation.this.client.projects().withName(name)).get();
                return "Project for " + name + " " + (actualProject == null ? "absent" : " status " + actualProject.getStatus());
            }
        };
        if (project != null) {
            LOG.debug("Found project {}, returning it.", (Object)project);
        } else if (create.booleanValue()) {
            project = (Project)this.client.projects().create((Object[])new Project[]{((ProjectBuilder)((ProjectFluent.MetadataNested)new ProjectBuilder().withNewMetadata().withName(name)).endMetadata()).build()});
            LOG.debug("Created project {}.", (Object)project);
        } else {
            throw new IllegalStateException("Project " + name + " does not exist and namespace.create is not set");
        }
        this.waitForExitCondition(projectReady);
        return (Namespace)((ClientResource)this.client.namespaces().withName(name)).get();
    }

    @Override
    protected synchronized void deleteEmptyNamespace(final String name) {
        if (!name.equals("default") && this.isNamespaceEmpty(name) && ((ClientResource)this.client.projects().withName(name)).get() != null && !((Project)((ClientResource)this.client.projects().withName(name)).get()).getStatus().getPhase().equals("Terminating")) {
            ((ClientResource)this.client.projects().withName(name)).delete();
            KubernetesLocation.ExitCondition exitCondition = new KubernetesLocation.ExitCondition(){

                @Override
                public Boolean call() {
                    return ((ClientResource)OpenShiftLocation.this.client.projects().withName(name)).get() == null;
                }

                @Override
                public String getFailureMessage() {
                    return "Project " + name + " still present";
                }
            };
            this.waitForExitCondition(exitCondition);
        }
    }

    @Override
    protected boolean isNamespaceEmpty(String namespace) {
        return ((DeploymentConfigList)((ClientNonNamespaceOperation)this.client.deploymentConfigs().inNamespace(namespace)).list()).getItems().isEmpty() && ((ServiceList)((ClientNonNamespaceOperation)this.client.services().inNamespace(namespace)).list()).getItems().isEmpty() && ((SecretList)((ClientNonNamespaceOperation)this.client.secrets().inNamespace(namespace)).list()).getItems().isEmpty();
    }

    @Override
    protected void deploy(final String namespace, Entity entity, Map<String, String> metadata, final String deploymentName, Container container, Integer replicas, Map<String, String> secrets) {
        PodTemplateSpecBuilder podTemplateSpecBuilder = (PodTemplateSpecBuilder)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)new PodTemplateSpecBuilder().withNewMetadata().addToLabels("name", deploymentName)).addToLabels(metadata)).endMetadata()).withNewSpec().addToContainers(new Container[]{container})).endSpec();
        if (secrets != null) {
            for (String secretName : secrets.keySet()) {
                ((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)podTemplateSpecBuilder.withNewSpec().addToContainers(new Container[]{container})).addNewImagePullSecret(secretName)).endSpec();
            }
        }
        PodTemplateSpec template = podTemplateSpecBuilder.build();
        DeploymentConfig deployment = ((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.StrategyNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(deploymentName)).addToAnnotations(OPENSHIFT_GENERATED_BY, "Apache Brooklyn")).addToAnnotations("brooklyn.apache.org/entity-id", entity.getId())).addToAnnotations("brooklyn.apache.org/application-id", entity.getApplicationId())).endMetadata()).withNewSpec().withNewStrategy().withType("Recreate")).endStrategy()).addNewTrigger().withType("ConfigChange")).endTrigger()).withReplicas(replicas)).addToSelector("name", deploymentName)).withTemplate(template)).endSpec()).build();
        ((ClientNonNamespaceOperation)this.client.deploymentConfigs().inNamespace(namespace)).create((Object[])new DeploymentConfig[]{deployment});
        KubernetesLocation.ExitCondition exitCondition = new KubernetesLocation.ExitCondition(){

            @Override
            public Boolean call() {
                DeploymentConfig dc = (DeploymentConfig)((ClientDeployableScalableResource)((ClientNonNamespaceOperation)OpenShiftLocation.this.client.deploymentConfigs().inNamespace(namespace)).withName(deploymentName)).get();
                DeploymentConfigStatus status = dc == null ? null : dc.getStatus();
                Integer replicas = status == null ? null : status.getAvailableReplicas();
                return replicas != null && replicas.intValue() == replicas.intValue();
            }

            @Override
            public String getFailureMessage() {
                DeploymentConfig dc = (DeploymentConfig)((ClientDeployableScalableResource)((ClientNonNamespaceOperation)OpenShiftLocation.this.client.deploymentConfigs().inNamespace(namespace)).withName(deploymentName)).get();
                DeploymentConfigStatus status = dc == null ? null : dc.getStatus();
                return "Namespace=" + namespace + "; deploymentName= " + deploymentName + "; Deployment=" + dc + "; status=" + status;
            }
        };
        this.waitForExitCondition(exitCondition);
        LOG.debug("Deployed {} to namespace {}.", (Object)deployment, (Object)namespace);
    }

    @Override
    protected String getContainerResourceType() {
        return "DeploymentConfig";
    }

    @Override
    protected void undeploy(final String namespace, final String deployment, String pod) {
        ((ClientDeployableScalableResource)((ClientNonNamespaceOperation)this.client.deploymentConfigs().inNamespace(namespace)).withName(deployment)).delete();
        KubernetesLocation.ExitCondition exitCondition = new KubernetesLocation.ExitCondition(){

            @Override
            public Boolean call() {
                return ((ClientDeployableScalableResource)((ClientNonNamespaceOperation)OpenShiftLocation.this.client.deploymentConfigs().inNamespace(namespace)).withName(deployment)).get() == null;
            }

            @Override
            public String getFailureMessage() {
                return "No deployment with namespace=" + namespace + ", deployment=" + deployment;
            }
        };
        this.waitForExitCondition(exitCondition);
    }
}

