/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.enricher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.ui.modularity.module.api.UiModule;
import org.apache.brooklyn.ui.modularity.module.api.UiModuleAction;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynExternalUiModuleEnricher
extends AbstractEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynExternalUiModuleEnricher.class);
    private static final Dictionary<String, ?> EMPTY_DICTIONARY = new Hashtable();
    public static final ConfigKey<String> MODULE_ICON = ConfigKeys.newStringConfigKey((String)"external.ui.module.icon", (String)"Module icon", (String)"fa-external-link");
    public static final ConfigKey<String> MODULE_NAME = ConfigKeys.newStringConfigKey((String)"external.ui.module.name", (String)"Module name");
    public static final ConfigKey<String> MODULE_SLUG = ConfigKeys.newStringConfigKey((String)"external.ui.module.slug", (String)"Module slug");
    public static final ConfigKey<List<String>> MODULE_TYPE = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"external.ui.module.types", (String)"Module types", (Object)ImmutableList.of());
    public static final ConfigKey<List<String>> SUPERSEDES_BUNDLES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"external.ui.module.supersedes", (String)"Bundles supersedes", (Object)ImmutableList.of());
    public static final ConfigKey<Boolean> STOP_EXISTING = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Boolean>(){}, (String)"external.ui.module.stopExisting", (String)"Module stops existing", (Object)true);
    public static final ConfigKey<Sensor<?>> MODULE_URL_SENSOR_TO_MONITOR = ConfigKeys.newConfigKey(Sensor.class, (String)"external.ui.module.url.sensor", (String)"Module URL Sensor", (Object)Attributes.MAIN_URI);
    private ServiceRegistration<UiModule> registration;

    public void setEntity(final EntityLocal entity) {
        super.setEntity(entity);
        if (this.getConfig(MODULE_NAME) == null) {
            this.config().set(MODULE_NAME, (Object)(entity.getDisplayName() + " UI"));
        }
        entity.subscriptions().subscribe((Entity)entity, (Sensor)Attributes.SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                if (event.getValue() != null && ((Boolean)event.getValue()).booleanValue()) {
                    BrooklynExternalUiModuleEnricher.this.register((String)entity.sensors().get((AttributeSensor)BrooklynExternalUiModuleEnricher.this.getConfig(MODULE_URL_SENSOR_TO_MONITOR)));
                } else {
                    BrooklynExternalUiModuleEnricher.this.unregister();
                }
            }
        });
        entity.subscriptions().subscribe((Entity)entity, (Sensor)this.getConfig(MODULE_URL_SENSOR_TO_MONITOR), (SensorEventListener)new SensorEventListener<Object>(){

            public void onEvent(SensorEvent<Object> event) {
                if (event.getValue() != null) {
                    BrooklynExternalUiModuleEnricher.this.register((String)TypeCoercions.coerce((Object)event.getValue(), String.class));
                }
            }
        });
    }

    private synchronized void register(String url) {
        try {
            this.unregister();
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            if (bundle == null) {
                LOG.debug("Could not register external UI module [{} :: {}] ... Could not load bundle context", (Object)this.getId(), this.getConfig(MODULE_NAME));
            } else {
                MutableSet types = MutableSet.builder().add((Object)"external-ui-module").addAll((Iterable)this.getConfig(MODULE_TYPE)).build();
                UiModule uiModule = this.newUiModule(this.getId(), (String)this.getConfig(MODULE_NAME), (String)this.getConfig(MODULE_SLUG), (Set<String>)types, url, (String)this.getConfig(MODULE_ICON), (Collection)this.getConfig(SUPERSEDES_BUNDLES), (Boolean)this.getConfig(STOP_EXISTING));
                this.registration = bundle.getBundleContext().registerService(UiModule.class, (Object)uiModule, EMPTY_DICTIONARY);
                LOG.debug("Registered external UI module [{} :: {}]", (Object)this.getId(), this.getConfig(MODULE_NAME));
            }
        }
        catch (Exception e) {
            LOG.info("Could not register external UI module [{} :: {}] ... {}", new Object[]{this.getId(), this.getConfig(MODULE_NAME), e.getMessage()});
        }
    }

    private synchronized void unregister() {
        if (this.registration != null) {
            try {
                this.registration.unregister();
                LOG.debug("Unregistered external UI module [{} :: {}]", (Object)this.getId(), this.getConfig(MODULE_NAME));
            }
            catch (IllegalStateException e) {
                LOG.debug("Could not unregister external UI module [{} :: {}]  ... {}", new Object[]{this.getId(), this.getConfig(MODULE_NAME), e.getMessage()});
            }
            this.registration = null;
        }
    }

    private UiModule newUiModule(final String id, final String name, final String slug, final Set<String> types, final String url, final String icon, final Collection<String> supersedes, final boolean stopExisting) {
        return new UiModule(){

            public String getId() {
                return id;
            }

            public String getName() {
                return name;
            }

            public String getSlug() {
                return slug;
            }

            public String getIcon() {
                return icon;
            }

            public Set<String> getTypes() {
                return types;
            }

            public String getPath() {
                return url;
            }

            public List<UiModuleAction> getActions() {
                return ImmutableList.of();
            }

            public Set<String> getSupersedesBundles() {
                return ImmutableSet.copyOf((Collection)supersedes);
            }

            public boolean getStopExisting() {
                return stopExisting;
            }
        };
    }
}

