/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.s3;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyEnvironmentVariableSetting;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.io.StandardRetryOptions;
import software.amazon.awssdk.crt.io.TlsConnectionOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.s3.ChecksumAlgorithm;
import software.amazon.awssdk.crt.s3.ChecksumConfig;
import software.amazon.awssdk.crt.s3.ResumeToken;
import software.amazon.awssdk.crt.s3.S3ClientOptions;
import software.amazon.awssdk.crt.s3.S3ExpressCredentialsProviderFactory;
import software.amazon.awssdk.crt.s3.S3MetaRequest;
import software.amazon.awssdk.crt.s3.S3MetaRequestOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandlerNativeAdapter;
import software.amazon.awssdk.crt.s3.S3TcpKeepAliveOptions;

public class S3Client
extends CrtResource {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();
    private final String region;

    public S3Client(S3ClientOptions options) throws CrtRuntimeException {
        TlsContext tlsCtx = options.getTlsContext();
        this.region = options.getRegion();
        int proxyConnectionType = 0;
        String proxyHost = null;
        int proxyPort = 0;
        TlsContext proxyTlsContext = null;
        int proxyAuthorizationType = 0;
        String proxyAuthorizationUsername = null;
        String proxyAuthorizationPassword = null;
        HttpProxyOptions proxyOptions = options.getProxyOptions();
        if (proxyOptions != null) {
            proxyConnectionType = proxyOptions.getConnectionType().getValue();
            proxyHost = proxyOptions.getHost();
            proxyPort = proxyOptions.getPort();
            proxyTlsContext = proxyOptions.getTlsContext();
            proxyAuthorizationType = proxyOptions.getAuthorizationType().getValue();
            proxyAuthorizationUsername = proxyOptions.getAuthorizationUsername();
            proxyAuthorizationPassword = proxyOptions.getAuthorizationPassword();
        }
        int environmentVariableProxyConnectionType = 0;
        TlsConnectionOptions environmentVariableProxyTlsConnectionOptions = null;
        int environmentVariableType = 1;
        HttpProxyEnvironmentVariableSetting environmentVariableSetting = options.getHttpProxyEnvironmentVariableSetting();
        if (environmentVariableSetting != null) {
            environmentVariableProxyConnectionType = environmentVariableSetting.getConnectionType().getValue();
            environmentVariableProxyTlsConnectionOptions = environmentVariableSetting.getTlsConnectionOptions();
            environmentVariableType = environmentVariableSetting.getEnvironmentVariableType().getValue();
        }
        HttpMonitoringOptions monitoringOptions = options.getMonitoringOptions();
        long monitoringThroughputThresholdInBytesPerSecond = 0L;
        int monitoringFailureIntervalInSeconds = 0;
        if (monitoringOptions != null) {
            monitoringThroughputThresholdInBytesPerSecond = monitoringOptions.getMinThroughputBytesPerSecond();
            monitoringFailureIntervalInSeconds = monitoringOptions.getAllowableThroughputFailureIntervalSeconds();
        }
        AwsSigningConfig signingConfig = options.getSigningConfig();
        boolean didCreateSigningConfig = false;
        if (signingConfig == null && options.getCredentialsProvider() != null) {
            signingConfig = AwsSigningConfig.getDefaultS3SigningConfig(this.region, options.getCredentialsProvider());
            didCreateSigningConfig = true;
        }
        this.acquireNativeHandle(S3Client.s3ClientNew(this, this.region.getBytes(UTF8), options.getClientBootstrap().getNativeHandle(), tlsCtx != null ? tlsCtx.getNativeHandle() : 0L, signingConfig, options.getPartSize(), options.getMultiPartUploadThreshold(), options.getThroughputTargetGbps(), options.getReadBackpressureEnabled(), options.getInitialReadWindowSize(), options.getMaxConnections(), options.getStandardRetryOptions(), options.getComputeContentMd5(), proxyConnectionType, proxyHost != null ? proxyHost.getBytes(UTF8) : null, proxyPort, proxyTlsContext != null ? proxyTlsContext.getNativeHandle() : 0L, proxyAuthorizationType, proxyAuthorizationUsername != null ? proxyAuthorizationUsername.getBytes(UTF8) : null, proxyAuthorizationPassword != null ? proxyAuthorizationPassword.getBytes(UTF8) : null, environmentVariableProxyConnectionType, environmentVariableProxyTlsConnectionOptions != null ? environmentVariableProxyTlsConnectionOptions.getNativeHandle() : 0L, environmentVariableType, options.getConnectTimeoutMs(), options.getTcpKeepAliveOptions(), monitoringThroughputThresholdInBytesPerSecond, monitoringFailureIntervalInSeconds, options.getEnableS3Express(), options.getS3ExpressCredentialsProviderFactory(), options.getMemoryLimitInBytes()));
        this.addReferenceTo(options.getClientBootstrap());
        if (didCreateSigningConfig) {
            signingConfig.close();
        }
    }

    private void onShutdownComplete() {
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    public S3MetaRequest makeMetaRequest(S3MetaRequestOptions options) {
        if (this.isNull()) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.S3Client, "S3Client.makeMetaRequest has invalid client. The client can not be used after it is closed.");
            throw new IllegalStateException("S3Client.makeMetaRequest has invalid client. The client can not be used after it is closed.");
        }
        if (options.getHttpRequest() == null) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.S3Client, "S3Client.makeMetaRequest has invalid options; Http Request cannot be null.");
            throw new IllegalArgumentException("S3Client.makeMetaRequest has invalid options; Http Request cannot be null.");
        }
        if (options.getResponseHandler() == null) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.S3Client, "S3Client.makeMetaRequest has invalid options; Response Handler cannot be null.");
            throw new IllegalArgumentException("S3Client.makeMetaRequest has invalid options; Response Handler cannot be null.");
        }
        S3MetaRequest metaRequest = new S3MetaRequest();
        S3MetaRequestResponseHandlerNativeAdapter responseHandlerNativeAdapter = new S3MetaRequestResponseHandlerNativeAdapter(options.getResponseHandler());
        byte[] httpRequestBytes = options.getHttpRequest().marshalForJni();
        byte[] requestFilePath = null;
        if (options.getRequestFilePath() != null) {
            requestFilePath = options.getRequestFilePath().toString().getBytes(UTF8);
        }
        AwsSigningConfig signingConfig = options.getSigningConfig();
        boolean didCreateSigningConfig = false;
        if (signingConfig == null && options.getCredentialsProvider() != null) {
            signingConfig = AwsSigningConfig.getDefaultS3SigningConfig(this.region, options.getCredentialsProvider());
            didCreateSigningConfig = true;
        }
        URI endpoint = options.getEndpoint();
        ChecksumConfig checksumConfig = options.getChecksumConfig() != null ? options.getChecksumConfig() : new ChecksumConfig();
        long metaRequestNativeHandle = S3Client.s3ClientMakeMetaRequest(this.getNativeHandle(), metaRequest, this.region.getBytes(UTF8), options.getMetaRequestType().getNativeValue(), checksumConfig.getChecksumLocation().getNativeValue(), checksumConfig.getChecksumAlgorithm().getNativeValue(), checksumConfig.getValidateChecksum(), ChecksumAlgorithm.marshallAlgorithmsForJNI(checksumConfig.getValidateChecksumAlgorithmList()), httpRequestBytes, options.getHttpRequest().getBodyStream(), requestFilePath, signingConfig, responseHandlerNativeAdapter, endpoint == null ? null : endpoint.toString().getBytes(UTF8), options.getResumeToken());
        metaRequest.setMetaRequestNativeHandle(metaRequestNativeHandle);
        if (didCreateSigningConfig) {
            signingConfig.close();
        }
        return metaRequest;
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            S3Client.s3ClientDestroy(this.getNativeHandle());
        }
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    private static native long s3ClientNew(S3Client var0, byte[] var1, long var2, long var4, AwsSigningConfig var6, long var7, long var9, double var11, boolean var13, long var14, int var16, StandardRetryOptions var17, boolean var18, int var19, byte[] var20, int var21, long var22, int var24, byte[] var25, byte[] var26, int var27, long var28, int var30, int var31, S3TcpKeepAliveOptions var32, long var33, int var35, boolean var36, S3ExpressCredentialsProviderFactory var37, long var38) throws CrtRuntimeException;

    private static native void s3ClientDestroy(long var0);

    private static native long s3ClientMakeMetaRequest(long var0, S3MetaRequest var2, byte[] var3, int var4, int var5, int var6, boolean var7, int[] var8, byte[] var9, HttpRequestBodyStream var10, byte[] var11, AwsSigningConfig var12, S3MetaRequestResponseHandlerNativeAdapter var13, byte[] var14, ResumeToken var15);
}

