/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.util.ArrayList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.impl.AbstractRecordFunctionTypeComputer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;

public class RecordPutTypeComputer
extends AbstractRecordFunctionTypeComputer {
    public static final RecordPutTypeComputer INSTANCE = new RecordPutTypeComputer();

    private RecordPutTypeComputer() {
    }

    @Override
    public IAType computeTypeImpl(AbstractFunctionCallExpression functionCallExpression, IVariableTypeEnvironment env, ARecordType inputRecordType, boolean isOutputMissable, boolean isOutputNullable) throws AlgebricksException {
        ARecordType outputRecordType;
        boolean doesRecordHaveTypeName;
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(2)).getValue();
        IAType type2 = (IAType)env.getType(arg2);
        IAType actualType2 = TypeComputeUtils.getActualType(type2);
        boolean isFieldRemoval = actualType2.getTypeTag() == ATypeTag.MISSING;
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return RecordPutTypeComputer.wrapTypeWithUnknown(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, isOutputMissable, isOutputNullable);
        }
        ConstantExpression constantExpression = (ConstantExpression)arg1;
        AsterixConstantValue constantValue = (AsterixConstantValue)constantExpression.getValue();
        String newFieldName = ((AString)constantValue.getObject()).getStringValue();
        boolean fieldFound = false;
        ArrayList<String> outputFieldNames = new ArrayList<String>();
        ArrayList<IAType> outputFieldTypes = new ArrayList<IAType>();
        for (int i = 0; i < inputRecordType.getFieldNames().length; ++i) {
            String inputFieldName = inputRecordType.getFieldNames()[i];
            IAType inputFieldType = inputRecordType.getFieldTypes()[i];
            if (!inputFieldName.equals(newFieldName)) {
                outputFieldNames.add(inputFieldName);
                outputFieldTypes.add(inputFieldType);
                continue;
            }
            fieldFound = true;
            if (isFieldRemoval) continue;
            outputFieldNames.add(inputFieldName);
            outputFieldTypes.add(type2);
        }
        String inputTypeName = inputRecordType.getTypeName();
        boolean bl = doesRecordHaveTypeName = inputTypeName != null;
        if (fieldFound && isFieldRemoval) {
            String outputTypeName = doesRecordHaveTypeName ? inputTypeName + "_remove_" + newFieldName : null;
            outputRecordType = new ARecordType(outputTypeName, (String[])outputFieldNames.toArray(String[]::new), (IAType[])outputFieldTypes.toArray(IAType[]::new), inputRecordType.isOpen());
        } else if (fieldFound) {
            String outputTypeName = doesRecordHaveTypeName ? inputTypeName + "_replaced_" + newFieldName : null;
            outputRecordType = new ARecordType(outputTypeName, (String[])outputFieldNames.toArray(String[]::new), (IAType[])outputFieldTypes.toArray(IAType[]::new), inputRecordType.isOpen());
        } else if (!isFieldRemoval) {
            outputFieldNames.add(newFieldName);
            outputFieldTypes.add(type2);
            String outputTypeName = doesRecordHaveTypeName ? inputTypeName + "_add_" + newFieldName : null;
            outputRecordType = new ARecordType(outputTypeName, (String[])outputFieldNames.toArray(String[]::new), (IAType[])outputFieldTypes.toArray(IAType[]::new), inputRecordType.isOpen());
        } else {
            outputRecordType = inputRecordType;
        }
        return RecordPutTypeComputer.wrapTypeWithUnknown(outputRecordType, isOutputMissable, isOutputNullable);
    }
}

