/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.Closeable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;

public interface RESTClient
extends Closeable {
    default public void head(String path, Supplier<Map<String, String>> headers, Consumer<ErrorResponse> errorHandler) {
        this.head(path, headers.get(), errorHandler);
    }

    public void head(String var1, Map<String, String> var2, Consumer<ErrorResponse> var3);

    default public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Supplier<Map<String, String>> headers, Consumer<ErrorResponse> errorHandler) {
        return this.delete(path, queryParams, responseType, headers.get(), errorHandler);
    }

    default public <T extends RESTResponse> T delete(String path, Class<T> responseType, Supplier<Map<String, String>> headers, Consumer<ErrorResponse> errorHandler) {
        return this.delete(path, (Map<String, String>)ImmutableMap.of(), responseType, headers.get(), errorHandler);
    }

    public <T extends RESTResponse> T delete(String var1, Class<T> var2, Map<String, String> var3, Consumer<ErrorResponse> var4);

    default public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        if (null != queryParams && !queryParams.isEmpty()) {
            throw new UnsupportedOperationException("Query params are not supported");
        }
        return this.delete(path, responseType, headers, errorHandler);
    }

    default public <T extends RESTResponse> T get(String path, Class<T> responseType, Supplier<Map<String, String>> headers, Consumer<ErrorResponse> errorHandler) {
        return this.get(path, (Map<String, String>)ImmutableMap.of(), responseType, headers, errorHandler);
    }

    default public <T extends RESTResponse> T get(String path, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.get(path, (Map<String, String>)ImmutableMap.of(), responseType, headers, errorHandler);
    }

    default public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Supplier<Map<String, String>> headers, Consumer<ErrorResponse> errorHandler) {
        return this.get(path, queryParams, responseType, headers.get(), errorHandler);
    }

    public <T extends RESTResponse> T get(String var1, Map<String, String> var2, Class<T> var3, Map<String, String> var4, Consumer<ErrorResponse> var5);

    default public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Supplier<Map<String, String>> headers, Consumer<ErrorResponse> errorHandler) {
        return this.post(path, body, responseType, headers.get(), errorHandler);
    }

    public <T extends RESTResponse> T post(String var1, RESTRequest var2, Class<T> var3, Map<String, String> var4, Consumer<ErrorResponse> var5);

    default public <T extends RESTResponse> T postForm(String path, Map<String, String> formData, Class<T> responseType, Supplier<Map<String, String>> headers, Consumer<ErrorResponse> errorHandler) {
        return this.postForm(path, formData, responseType, headers.get(), errorHandler);
    }

    public <T extends RESTResponse> T postForm(String var1, Map<String, String> var2, Class<T> var3, Map<String, String> var4, Consumer<ErrorResponse> var5);
}

