/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionParser;
import org.apache.iceberg.metrics.ImmutableScanReport;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.iceberg.metrics.ScanMetricsResultParser;
import org.apache.iceberg.metrics.ScanReport;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

public class ScanReportParser {
    private static final String TABLE_NAME = "table-name";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String FILTER = "filter";
    private static final String SCHEMA_ID = "schema-id";
    private static final String PROJECTED_FIELD_IDS = "projected-field-ids";
    private static final String PROJECTED_FIELD_NAMES = "projected-field-names";
    private static final String METRICS = "metrics";
    private static final String METADATA = "metadata";

    private ScanReportParser() {
    }

    public static String toJson(ScanReport scanReport) {
        return ScanReportParser.toJson(scanReport, false);
    }

    public static String toJson(ScanReport scanReport, boolean pretty) {
        return JsonUtil.generate(gen -> ScanReportParser.toJson(scanReport, gen), pretty);
    }

    public static void toJson(ScanReport scanReport, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != scanReport ? 1 : 0) != 0, (Object)"Invalid scan report: null");
        gen.writeStartObject();
        ScanReportParser.toJsonWithoutStartEnd(scanReport, gen);
        gen.writeEndObject();
    }

    public static void toJsonWithoutStartEnd(ScanReport scanReport, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != scanReport ? 1 : 0) != 0, (Object)"Invalid scan report: null");
        gen.writeStringField(TABLE_NAME, scanReport.tableName());
        gen.writeNumberField(SNAPSHOT_ID, scanReport.snapshotId());
        gen.writeFieldName(FILTER);
        ExpressionParser.toJson(scanReport.filter(), gen);
        gen.writeNumberField(SCHEMA_ID, scanReport.schemaId());
        JsonUtil.writeIntegerArray(PROJECTED_FIELD_IDS, scanReport.projectedFieldIds(), gen);
        JsonUtil.writeStringArray(PROJECTED_FIELD_NAMES, scanReport.projectedFieldNames(), gen);
        gen.writeFieldName(METRICS);
        ScanMetricsResultParser.toJson(scanReport.scanMetrics(), gen);
        if (!scanReport.metadata().isEmpty()) {
            gen.writeObjectFieldStart(METADATA);
            for (Map.Entry<String, String> entry : scanReport.metadata().entrySet()) {
                gen.writeStringField(entry.getKey(), entry.getValue());
            }
            gen.writeEndObject();
        }
    }

    public static ScanReport fromJson(String json) {
        return JsonUtil.parse(json, ScanReportParser::fromJson);
    }

    public static ScanReport fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse scan report from null object");
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse scan report from non-object: %s", (Object)json);
        String tableName = JsonUtil.getString(TABLE_NAME, json);
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, json);
        Expression filter = ExpressionParser.fromJson(JsonUtil.get(FILTER, json));
        int schemaId = JsonUtil.getInt(SCHEMA_ID, json);
        List<Integer> projectedFieldIds = JsonUtil.getIntegerList(PROJECTED_FIELD_IDS, json);
        List<String> projectedFieldNames = JsonUtil.getStringList(PROJECTED_FIELD_NAMES, json);
        ScanMetricsResult scanMetricsResult = ScanMetricsResultParser.fromJson(JsonUtil.get(METRICS, json));
        ImmutableScanReport.Builder builder = ImmutableScanReport.builder().tableName(tableName).snapshotId(snapshotId).schemaId(schemaId).projectedFieldIds(projectedFieldIds).projectedFieldNames(projectedFieldNames).filter(filter).scanMetrics(scanMetricsResult);
        if (json.has(METADATA)) {
            builder.metadata(JsonUtil.getStringMap(METADATA, json));
        }
        return builder.build();
    }
}

