/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.asterix.external.library.msgpack.MessagePackUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.JavaSerializationUtils;

public class PythonMessageBuilder {
    MessageType type = null;
    long dataLength = -1L;
    private final ByteBuffer buf = ByteBuffer.allocate(4096);

    public void reset() {
        this.buf.clear();
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }

    public int getLength() {
        return this.buf.position() - this.buf.arrayOffset();
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public void packHeader() throws HyracksDataException {
        MessagePackUtils.packFixPos(this.buf, (byte)this.type.ordinal());
    }

    private static int getStringLength(String s) {
        return s.length();
    }

    public void readHead(ByteBuffer buf) {
        byte typ = buf.get();
        this.type = MessageType.fromByte(typ);
    }

    public void hello() throws IOException {
        this.type = MessageType.HELO;
        byte[] serAddr = this.serialize(new InetSocketAddress(InetAddress.getLoopbackAddress(), 1));
        this.dataLength = serAddr.length + 1;
        this.packHeader();
        this.buf.put((byte)-58);
        this.buf.putInt(serAddr.length);
        this.buf.put(serAddr);
    }

    public void quit() throws HyracksDataException {
        this.type = MessageType.QUIT;
        this.dataLength = PythonMessageBuilder.getStringLength("QUIT");
        this.packHeader();
        MessagePackUtils.packFixStr(this.buf, "QUIT");
    }

    public void init(String module, String clazz, String fn) throws HyracksDataException {
        this.type = MessageType.INIT;
        this.dataLength = clazz != null ? (long)(PythonMessageBuilder.getStringLength(module) + PythonMessageBuilder.getStringLength(clazz) + PythonMessageBuilder.getStringLength(fn) + 2) : (long)(PythonMessageBuilder.getStringLength(module) + PythonMessageBuilder.getStringLength(fn) + 2);
        this.packHeader();
        int numArgs = clazz == null ? 2 : 3;
        MessagePackUtils.packFixArrayHeader(this.buf, (byte)numArgs);
        MessagePackUtils.packStr(this.buf, module);
        if (clazz != null) {
            MessagePackUtils.packStr(this.buf, clazz);
        }
        MessagePackUtils.packStr(this.buf, fn);
    }

    public void call(int numArgs, int len) throws HyracksDataException {
        this.buf.clear();
        this.buf.position(0);
        this.type = MessageType.CALL;
        this.dataLength = 6 + len;
        this.packHeader();
        this.buf.put((byte)-111);
        this.buf.put((byte)-36);
        this.buf.putShort((short)numArgs);
    }

    public void callMulti(int lim, int numArgs) throws HyracksDataException {
        this.buf.clear();
        this.buf.position(0);
        this.type = MessageType.CALL;
        this.dataLength = 6 + lim;
        this.packHeader();
        this.buf.put((byte)-36);
        this.buf.putShort((short)numArgs);
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = JavaSerializationUtils.getSerializationProvider().newObjectOutputStream((OutputStream)baos);){
            oos.writeObject(object);
            oos.flush();
            baos.close();
        }
        return baos.toByteArray();
    }
}

