/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedByIteratorBase;
import com.azure.core.util.paging.ContinuationState;
import com.azure.core.util.paging.PageRetriever;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;

final class ContinuablePagedByItemIterable<C, T, P extends ContinuablePage<C, T>>
implements Iterable<T> {
    private final PageRetriever<C, P> pageRetriever;
    private final C continuationToken;
    private final Predicate<C> continuationPredicate;
    private final Integer preferredPageSize;

    ContinuablePagedByItemIterable(PageRetriever<C, P> pageRetriever, C continuationToken, Predicate<C> continuationPredicate, Integer preferredPageSize) {
        this.pageRetriever = pageRetriever;
        this.continuationToken = continuationToken;
        this.continuationPredicate = continuationPredicate;
        this.preferredPageSize = preferredPageSize;
    }

    @Override
    public Iterator<T> iterator() {
        return new ContinuablePagedByItemIterator(this.pageRetriever, this.continuationToken, this.continuationPredicate, this.preferredPageSize);
    }

    private static final class ContinuablePagedByItemIterator<C, T, P extends ContinuablePage<C, T>>
    extends ContinuablePagedByIteratorBase<C, T, P, T> {
        private volatile Queue<Iterator<T>> pages = new ConcurrentLinkedQueue<Iterator<T>>();
        private volatile Iterator<T> currentPage;

        ContinuablePagedByItemIterator(PageRetriever<C, P> pageRetriever, C continuationToken, Predicate<C> continuationPredicate, Integer preferredPageSize) {
            super(pageRetriever, new ContinuationState<C>(continuationToken, continuationPredicate), preferredPageSize, new ClientLogger(ContinuablePagedByItemIterator.class));
            this.requestPage();
        }

        @Override
        boolean needToRequestPage() {
            return (this.currentPage == null || !this.currentPage.hasNext()) && this.pages.peek() == null;
        }

        @Override
        public boolean isNextAvailable() {
            return this.currentPage != null && this.currentPage.hasNext() || this.pages.peek() != null;
        }

        @Override
        T getNext() {
            if (!(this.currentPage != null && this.currentPage.hasNext() || this.pages.peek() == null)) {
                this.currentPage = this.pages.poll();
            }
            return this.currentPage.next();
        }

        @Override
        void addPage(P page) {
            Iterator pageValues = page.getElements().iterator();
            if (pageValues.hasNext()) {
                this.pages.add(pageValues);
            }
        }
    }
}

