/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.client.stats.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.job.profiling.counters.ICounter;
import org.apache.hyracks.client.stats.AggregateCounter;
import org.apache.hyracks.client.stats.IClusterCounterContext;

public class ClientCounterContext
implements IClusterCounterContext {
    private static String[] RESET_COUNTERS = new String[]{"net-payload-bytes-read", "net-payload-bytes-written", "heap-used-sizes", "heap-max-sizes", "disk-reads", "disk-writes", "num-processors"};
    private static String[] AGG_COUNTERS = new String[]{"system-load-averages"};
    private static int UPDATE_INTERVAL = 10000;
    private final Map<String, Counter> counterMap = new HashMap<String, Counter>();
    private final String baseURL;
    private final List<String> slaveMachines = new ArrayList<String>();
    private boolean stopped = false;
    private Thread updateThread = new UpdateThread();

    public ClientCounterContext(String hostName, int restPort, Collection<String> slaveMachines) {
        this.baseURL = "http://" + hostName + ":" + restPort + "/rest/nodes/";
        this.slaveMachines.addAll(slaveMachines);
        for (String restCounterName : RESET_COUNTERS) {
            this.counterMap.put(restCounterName, new AggregateCounter(restCounterName));
        }
        for (String aggCounterName : AGG_COUNTERS) {
            this.counterMap.put(aggCounterName, new AggregateCounter(aggCounterName));
        }
        for (String slave : slaveMachines) {
            for (String restCounterName : RESET_COUNTERS) {
                this.counterMap.put(slave + "$" + restCounterName, new AggregateCounter(restCounterName));
            }
            for (String aggCounterName : AGG_COUNTERS) {
                this.counterMap.put(slave + "$" + aggCounterName, new AggregateCounter(aggCounterName));
            }
        }
        this.requestCounters();
        this.updateThread.start();
    }

    public void reset() {
        for (String aggCounterName : RESET_COUNTERS) {
            AggregateCounter aggCounter = (AggregateCounter)this.counterMap.get(aggCounterName);
            aggCounter.reset();
        }
        for (String slave : this.slaveMachines) {
            for (String aggCounterName : RESET_COUNTERS) {
                AggregateCounter aggCounter = (AggregateCounter)this.counterMap.get(slave + "$" + aggCounterName);
                aggCounter.reset();
            }
        }
    }

    public void resetAll() {
        this.reset();
        for (String aggCounterName : AGG_COUNTERS) {
            AggregateCounter aggCounter = (AggregateCounter)this.counterMap.get(aggCounterName);
            aggCounter.reset();
        }
        for (String slave : this.slaveMachines) {
            for (String aggCounterName : AGG_COUNTERS) {
                AggregateCounter aggCounter = (AggregateCounter)this.counterMap.get(slave + "$" + aggCounterName);
                aggCounter.reset();
            }
        }
    }

    public synchronized ICounter getCounter(String name, boolean create) {
        Counter counter = this.counterMap.get(name);
        if (counter == null) {
            throw new IllegalStateException("request an unknown counter: " + name + "!");
        }
        return counter;
    }

    @Override
    public ICounter getCounter(String machineName, String counterName, boolean create) {
        Counter counter = this.counterMap.get(machineName + "$" + counterName);
        if (counter == null) {
            throw new IllegalStateException("request an unknown counter: " + counterName + " on slave machine " + machineName + "!");
        }
        return counter;
    }

    private synchronized void requestCounters() {
        try {
            this.reset();
            Iterator<String> iterator = this.slaveMachines.iterator();
            while (iterator.hasNext()) {
                ObjectMapper parser = new ObjectMapper();
                String slave = iterator.next();
                String slaveProfile = this.requestProfile(slave);
                JsonNode jo = parser.readTree(slaveProfile);
                JsonNode counterObject = jo.get("result");
                if (!counterObject.isObject()) continue;
                this.updateCounterMapWithArrayNode(slave, counterObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateCounterMapWithArrayNode(String slave, JsonNode jo) {
        for (String counterName : RESET_COUNTERS) {
            this.updateCounter(slave, jo, counterName);
        }
        for (String counterName : AGG_COUNTERS) {
            this.updateCounter(slave, jo, counterName);
        }
    }

    private void updateCounter(String slave, JsonNode jo, String counterName) {
        JsonNode counterObject = jo.get(counterName);
        long counterValue = this.extractCounterValue(counterObject);
        ICounter counter = this.getCounter(counterName, true);
        counter.set(counterValue);
        ICounter localCounter = this.getCounter(slave, counterName, true);
        localCounter.set(counterValue);
    }

    private long extractCounterValue(JsonNode counterObject) {
        long counterValue = 0L;
        if (counterObject == null) {
            return counterValue;
        }
        if (counterObject.isObject()) {
            for (JsonNode value : counterObject) {
                long currentVal;
                if (value.isDouble()) {
                    double currentVal2 = value.asDouble();
                    if (currentVal2 == 0.0) continue;
                    counterValue = (long)currentVal2;
                    continue;
                }
                if (!value.isLong() || (currentVal = value.asLong()) == 0L) continue;
                counterValue = currentVal;
            }
        } else {
            counterValue = counterObject.asLong();
        }
        return counterValue;
    }

    private String requestProfile(String slaveMachine) {
        try {
            String inputLine;
            String url = this.baseURL + slaveMachine;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                throw new IllegalStateException("The http response code is wrong: " + responseCode);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        catch (Exception e) {
            if (!(e instanceof ConnectException) && !(e instanceof IOException)) {
                throw new IllegalStateException(e);
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread thread = this.updateThread;
        synchronized (thread) {
            this.stopped = true;
            this.updateThread.notifyAll();
        }
        try {
            this.updateThread.join();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
        }

        @Override
        public synchronized void run() {
            try {
                while (!ClientCounterContext.this.stopped) {
                    ClientCounterContext.this.requestCounters();
                    this.wait(UPDATE_INTERVAL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.notifyAll();
            }
        }
    }
}

