/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.ProducedVariableVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.SchemaVariableVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.SubstituteVariableVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.UsedVariableVisitor;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;

public class VariableUtilities {
    public static void getUsedVariables(ILogicalOperator op, Collection<LogicalVariable> usedVariables) throws AlgebricksException {
        UsedVariableVisitor visitor = new UsedVariableVisitor(usedVariables);
        op.accept(visitor, null);
    }

    public static void getProducedVariables(ILogicalOperator op, Collection<LogicalVariable> producedVariables) throws AlgebricksException {
        ProducedVariableVisitor visitor = new ProducedVariableVisitor(producedVariables);
        op.accept(visitor, null);
    }

    public static void getLiveVariables(ILogicalOperator op, Collection<LogicalVariable> schemaVariables) throws AlgebricksException {
        SchemaVariableVisitor visitor = new SchemaVariableVisitor(schemaVariables);
        op.accept(visitor, null);
    }

    public static void getSubplanLocalLiveVariables(ILogicalOperator op, Collection<LogicalVariable> liveVariables) throws AlgebricksException {
        VariableUtilities.getLiveVariables(op, liveVariables);
        HashSet<LogicalVariable> locallyProducedVars = new HashSet<LogicalVariable>();
        VariableUtilities.getProducedVariablesInDescendantsAndSelf(op, locallyProducedVars);
        liveVariables.retainAll(locallyProducedVars);
    }

    public static void getUsedVariablesInDescendantsAndSelf(ILogicalOperator op, Collection<LogicalVariable> vars) throws AlgebricksException {
        VariableUtilities.getUsedVariables(op, vars);
        for (Mutable<ILogicalOperator> c : op.getInputs()) {
            VariableUtilities.getUsedVariablesInDescendantsAndSelf((ILogicalOperator)c.getValue(), vars);
        }
    }

    public static void getLiveVariablesInDescendantDataScans(ILogicalOperator op, Collection<LogicalVariable> vars) throws AlgebricksException {
        if (op.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            VariableUtilities.getLiveVariables(op, vars);
        }
        for (Mutable<ILogicalOperator> c : op.getInputs()) {
            VariableUtilities.getLiveVariablesInDescendantDataScans((ILogicalOperator)c.getValue(), vars);
        }
    }

    public static void getProducedVariablesInDescendantsAndSelf(ILogicalOperator op, Collection<LogicalVariable> vars) throws AlgebricksException {
        VariableUtilities.getProducedVariables(op, vars);
        for (Mutable<ILogicalOperator> c : op.getInputs()) {
            VariableUtilities.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)c.getValue(), vars);
        }
    }

    public static void substituteVariables(ILogicalOperator op, LogicalVariable v1, LogicalVariable v2, ITypingContext ctx) throws AlgebricksException {
        VariableUtilities.substituteVariables(op, v1, v2, true, ctx);
    }

    public static void substituteVariables(ILogicalOperator op, Map<LogicalVariable, LogicalVariable> varMap, ITypingContext ctx) throws AlgebricksException {
        for (Map.Entry<LogicalVariable, LogicalVariable> entry : varMap.entrySet()) {
            VariableUtilities.substituteVariables(op, entry.getKey(), entry.getValue(), ctx);
        }
    }

    public static void substituteVariables(ILogicalOperator op, List<Pair<LogicalVariable, LogicalVariable>> oldVarNewVarMapHistory, ITypingContext ctx) throws AlgebricksException {
        for (Pair<LogicalVariable, LogicalVariable> entry : oldVarNewVarMapHistory) {
            VariableUtilities.substituteVariables(op, (LogicalVariable)entry.first, (LogicalVariable)entry.second, ctx);
        }
    }

    public static void substituteVariablesInDescendantsAndSelf(ILogicalOperator op, LogicalVariable v1, LogicalVariable v2, ITypingContext ctx) throws AlgebricksException {
        for (Mutable<ILogicalOperator> childOp : op.getInputs()) {
            VariableUtilities.substituteVariablesInDescendantsAndSelf((ILogicalOperator)childOp.getValue(), v1, v2, ctx);
        }
        VariableUtilities.substituteVariables(op, v1, v2, true, ctx);
    }

    public static void substituteVariablesInDescendantsAndSelf(ILogicalOperator op, Map<LogicalVariable, LogicalVariable> varMap, ITypingContext ctx) throws AlgebricksException {
        for (Map.Entry<LogicalVariable, LogicalVariable> entry : varMap.entrySet()) {
            for (Mutable<ILogicalOperator> childOp : op.getInputs()) {
                VariableUtilities.substituteVariablesInDescendantsAndSelf((ILogicalOperator)childOp.getValue(), entry.getKey(), entry.getValue(), ctx);
            }
            VariableUtilities.substituteVariables(op, entry.getKey(), entry.getValue(), true, ctx);
        }
    }

    public static void substituteVariables(ILogicalOperator op, LogicalVariable v1, LogicalVariable v2, boolean goThroughNts, ITypingContext ctx) throws AlgebricksException {
        SubstituteVariableVisitor visitor = new SubstituteVariableVisitor(goThroughNts, ctx);
        op.accept(visitor, new Pair((Object)Objects.requireNonNull(v1), (Object)Objects.requireNonNull(v2)));
    }

    public static <T> boolean varListEqualUnordered(List<T> var, List<T> varArg) {
        HashSet<T> varSet = new HashSet<T>();
        HashSet<T> varArgSet = new HashSet<T>();
        varSet.addAll(var);
        varArgSet.addAll(varArg);
        return varSet.equals(varArgSet);
    }

    public static LogicalVariable getVariable(ILogicalExpression expr) {
        if (expr != null && expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return ((VariableReferenceExpression)expr).getVariableReference();
        }
        return null;
    }
}

