/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class CreateFeedPolicyStatement
extends AbstractStatement {
    private final String policyName;
    private final String sourcePolicyName;
    private final Map<String, String> properties;
    private final String sourcePolicyFile;
    private final String description;
    private final boolean ifNotExists;

    public CreateFeedPolicyStatement(String policyName, String sourcePolicyName, Map<String, String> properties, String description, boolean ifNotExists) {
        this.policyName = policyName;
        this.sourcePolicyName = sourcePolicyName;
        this.properties = properties;
        this.description = description;
        this.ifNotExists = ifNotExists;
        this.sourcePolicyFile = null;
    }

    public CreateFeedPolicyStatement(String policyName, String sourcePolicyFile, String description, boolean ifNotExists) {
        this.policyName = policyName;
        this.sourcePolicyName = null;
        this.sourcePolicyFile = sourcePolicyFile;
        this.description = description;
        this.properties = null;
        this.ifNotExists = ifNotExists;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_FEED_POLICY;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getSourcePolicyName() {
        return this.sourcePolicyName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getSourcePolicyFile() {
        return this.sourcePolicyFile;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

