/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv;

import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.AbstractKeyValueResponse;

public class ObserveResponse
extends AbstractKeyValueResponse {
    private final ObserveStatus observeStatus;
    private final boolean master;
    private final long cas;

    public ObserveResponse(ResponseStatus status, short serverStatusCode, byte obs, boolean master, long cas, String bucket, CouchbaseRequest request) {
        super(status, serverStatusCode, bucket, null, request);
        this.observeStatus = ObserveStatus.valueOf(obs);
        this.master = master;
        this.cas = cas;
    }

    public ObserveStatus observeStatus() {
        return this.observeStatus;
    }

    public boolean master() {
        return this.master;
    }

    public long cas() {
        return this.cas;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ObserveResponse{");
        sb.append("observeStatus=").append((Object)this.observeStatus);
        sb.append(", master=").append(this.master);
        sb.append(", cas=").append(this.cas);
        sb.append('}');
        return sb.toString();
    }

    public static enum ObserveStatus {
        UNKNOWN(-16),
        UNINITIALIZED(-1),
        MODIFIED(-2),
        FOUND_PERSISTED(1),
        FOUND_NOT_PERSISTED(0),
        NOT_FOUND_PERSISTED(-128),
        NOT_FOUND_NOT_PERSISTED(-127);

        private final byte value;

        private ObserveStatus(byte b) {
            this.value = b;
        }

        public static ObserveStatus valueOf(byte b) {
            switch (b) {
                case 0: {
                    return FOUND_NOT_PERSISTED;
                }
                case 1: {
                    return FOUND_PERSISTED;
                }
                case -128: {
                    return NOT_FOUND_PERSISTED;
                }
                case -127: {
                    return NOT_FOUND_NOT_PERSISTED;
                }
                case -2: {
                    return MODIFIED;
                }
                case -16: {
                    return UNKNOWN;
                }
            }
            return UNINITIALIZED;
        }

        public byte value() {
            return this.value;
        }
    }
}

