/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.SleepingAction;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.Subscriptions;

public final class ImmediateScheduler
extends Scheduler {
    public static final ImmediateScheduler INSTANCE = new ImmediateScheduler();

    private ImmediateScheduler() {
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new InnerImmediateScheduler();
    }

    private class InnerImmediateScheduler
    extends Scheduler.Worker
    implements Subscription {
        final BooleanSubscription innerSubscription = new BooleanSubscription();

        private InnerImmediateScheduler() {
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            long execTime = ImmediateScheduler.this.now() + unit.toMillis(delayTime);
            return this.schedule(new SleepingAction(action, this, execTime));
        }

        @Override
        public Subscription schedule(Action0 action) {
            action.call();
            return Subscriptions.unsubscribed();
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

