/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class SpdyStream {
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    private final int id;
    private final SpdyConnection connection;
    private final List<Header> requestHeaders;
    private List<Header> responseHeaders;
    private final SpdyDataSource source;
    final SpdyDataSink sink;
    private final SpdyTimeout readTimeout = new SpdyTimeout();
    private final SpdyTimeout writeTimeout = new SpdyTimeout();
    private ErrorCode errorCode = null;

    SpdyStream(int id, SpdyConnection connection, boolean outFinished, boolean inFinished, List<Header> requestHeaders) {
        if (connection == null) {
            throw new NullPointerException("connection == null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders == null");
        }
        this.id = id;
        this.connection = connection;
        this.bytesLeftInWriteWindow = connection.peerSettings.getInitialWindowSize(65536);
        this.source = new SpdyDataSource(connection.okHttpSettings.getInitialWindowSize(65536));
        this.sink = new SpdyDataSink();
        this.source.finished = inFinished;
        this.sink.finished = outFinished;
        this.requestHeaders = requestHeaders;
    }

    public int getId() {
        return this.id;
    }

    public synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.finished && !this.source.closed || !this.sink.finished && !this.sink.closed || this.responseHeaders == null;
    }

    public boolean isLocallyInitiated() {
        boolean streamIsClient = (this.id & 1) == 1;
        return this.connection.client == streamIsClient;
    }

    public SpdyConnection getConnection() {
        return this.connection;
    }

    public List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public synchronized List<Header> getResponseHeaders() throws IOException {
        this.readTimeout.enter();
        try {
            while (this.responseHeaders == null && this.errorCode == null) {
                this.waitForIo();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        if (this.responseHeaders != null) {
            return this.responseHeaders;
        }
        throw new IOException("stream was reset: " + (Object)((Object)this.errorCode));
    }

    public synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(List<Header> responseHeaders, boolean out) throws IOException {
        assert (!Thread.holdsLock(this));
        boolean outFinished = false;
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (responseHeaders == null) {
                throw new NullPointerException("responseHeaders == null");
            }
            if (this.responseHeaders != null) {
                throw new IllegalStateException("reply already sent");
            }
            this.responseHeaders = responseHeaders;
            if (!out) {
                this.sink.finished = true;
                outFinished = true;
            }
        }
        this.connection.writeSynReply(this.id, outFinished, responseHeaders);
        if (outFinished) {
            this.connection.flush();
        }
    }

    public Timeout readTimeout() {
        return this.readTimeout;
    }

    public Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public Source getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink getSink() {
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.responseHeaders == null && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the sink");
            }
        }
        return this.sink;
    }

    public void close(ErrorCode rstStatusCode) throws IOException {
        if (!this.closeInternal(rstStatusCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, rstStatusCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(ErrorCode errorCode) {
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.errorCode != null) {
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                return false;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeaders(List<Header> headers, HeadersMode headersMode) {
        assert (!Thread.holdsLock(this));
        ErrorCode errorCode = null;
        boolean open = true;
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.responseHeaders == null) {
                if (headersMode.failIfHeadersAbsent()) {
                    errorCode = ErrorCode.PROTOCOL_ERROR;
                } else {
                    this.responseHeaders = headers;
                    open = this.isOpen();
                    this.notifyAll();
                }
            } else if (headersMode.failIfHeadersPresent()) {
                errorCode = ErrorCode.STREAM_IN_USE;
            } else {
                ArrayList<Header> newHeaders = new ArrayList<Header>();
                newHeaders.addAll(this.responseHeaders);
                newHeaders.addAll(headers);
                this.responseHeaders = newHeaders;
            }
        }
        if (errorCode != null) {
            this.closeLater(errorCode);
        } else if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    void receiveData(BufferedSource in, int length) throws IOException {
        assert (!Thread.holdsLock(this));
        this.source.receive(in, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFin() {
        boolean open;
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            this.source.finished = true;
            open = this.isOpen();
            this.notifyAll();
        }
        if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelStreamIfNecessary() throws IOException {
        boolean open;
        boolean cancel;
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            cancel = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
            open = this.isOpen();
        }
        if (cancel) {
            this.close(ErrorCode.CANCEL);
        } else if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    void addBytesToWriteWindow(long delta) {
        this.bytesLeftInWriteWindow += delta;
        if (delta > 0L) {
            this.notifyAll();
        }
    }

    private void checkOutNotClosed() throws IOException {
        if (this.sink.closed) {
            throw new IOException("stream closed");
        }
        if (this.sink.finished) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            throw new IOException("stream was reset: " + (Object)((Object)this.errorCode));
        }
    }

    private void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    class SpdyTimeout
    extends AsyncTimeout {
        SpdyTimeout() {
        }

        protected void timedOut() {
            SpdyStream.this.closeLater(ErrorCode.CANCEL);
        }

        public void exitAndThrowIfTimedOut() throws InterruptedIOException {
            if (this.exit()) {
                throw new InterruptedIOException("timeout");
            }
        }
    }

    final class SpdyDataSink
    implements Sink {
        private static final long EMIT_BUFFER_SIZE = 16384L;
        private final Buffer sendBuffer = new Buffer();
        private boolean closed;
        private boolean finished;

        SpdyDataSink() {
        }

        public void write(Buffer source, long byteCount) throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            this.sendBuffer.write(source, byteCount);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitDataFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitDataFrame(boolean outFinished) throws IOException {
            long toWrite;
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                SpdyStream.this.writeTimeout.enter();
                try {
                    while (SpdyStream.this.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && SpdyStream.this.errorCode == null) {
                        SpdyStream.this.waitForIo();
                    }
                }
                finally {
                    SpdyStream.this.writeTimeout.exitAndThrowIfTimedOut();
                }
                SpdyStream.this.checkOutNotClosed();
                toWrite = Math.min(SpdyStream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                SpdyStream.this.bytesLeftInWriteWindow -= toWrite;
            }
            SpdyStream.this.writeTimeout.enter();
            try {
                SpdyStream.this.connection.writeData(SpdyStream.this.id, outFinished && toWrite == this.sendBuffer.size(), this.sendBuffer, toWrite);
            }
            finally {
                SpdyStream.this.writeTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                SpdyStream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitDataFrame(false);
                SpdyStream.this.connection.flush();
            }
        }

        public Timeout timeout() {
            return SpdyStream.this.writeTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                if (this.closed) {
                    return;
                }
            }
            if (!SpdyStream.this.sink.finished) {
                if (this.sendBuffer.size() > 0L) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitDataFrame(true);
                    }
                } else {
                    SpdyStream.this.connection.writeData(SpdyStream.this.id, true, null, 0L);
                }
            }
            spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                this.closed = true;
            }
            SpdyStream.this.connection.flush();
            SpdyStream.this.cancelStreamIfNecessary();
        }
    }

    private final class SpdyDataSource
    implements Source {
        private final Buffer receiveBuffer = new Buffer();
        private final Buffer readBuffer = new Buffer();
        private final long maxByteCount;
        private boolean closed;
        private boolean finished;

        private SpdyDataSource(long maxByteCount) {
            this.maxByteCount = maxByteCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long read(Buffer sink, long byteCount) throws IOException {
            long read;
            if (byteCount < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + byteCount);
            }
            Object object = SpdyStream.this;
            synchronized (object) {
                this.waitUntilReadable();
                this.checkNotClosed();
                if (this.readBuffer.size() == 0L) {
                    return -1L;
                }
                read = this.readBuffer.read(sink, Math.min(byteCount, this.readBuffer.size()));
                SpdyStream.this.unacknowledgedBytesRead += read;
                if (SpdyStream.this.unacknowledgedBytesRead >= (long)(((SpdyStream)SpdyStream.this).connection.okHttpSettings.getInitialWindowSize(65536) / 2)) {
                    SpdyStream.this.connection.writeWindowUpdateLater(SpdyStream.this.id, SpdyStream.this.unacknowledgedBytesRead);
                    SpdyStream.this.unacknowledgedBytesRead = 0L;
                }
            }
            object = SpdyStream.this.connection;
            synchronized (object) {
                ((SpdyStream)SpdyStream.this).connection.unacknowledgedBytesRead += read;
                if (((SpdyStream)SpdyStream.this).connection.unacknowledgedBytesRead >= (long)(((SpdyStream)SpdyStream.this).connection.okHttpSettings.getInitialWindowSize(65536) / 2)) {
                    SpdyStream.this.connection.writeWindowUpdateLater(0, ((SpdyStream)SpdyStream.this).connection.unacknowledgedBytesRead);
                    ((SpdyStream)SpdyStream.this).connection.unacknowledgedBytesRead = 0L;
                }
            }
            return read;
        }

        private void waitUntilReadable() throws IOException {
            SpdyStream.this.readTimeout.enter();
            try {
                while (this.readBuffer.size() == 0L && !this.finished && !this.closed && SpdyStream.this.errorCode == null) {
                    SpdyStream.this.waitForIo();
                }
            }
            finally {
                SpdyStream.this.readTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void receive(BufferedSource in, long byteCount) throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            while (byteCount > 0L) {
                boolean flowControlError;
                boolean finished;
                SpdyStream spdyStream = SpdyStream.this;
                synchronized (spdyStream) {
                    finished = this.finished;
                    flowControlError = byteCount + this.readBuffer.size() > this.maxByteCount;
                }
                if (flowControlError) {
                    in.skip(byteCount);
                    SpdyStream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (finished) {
                    in.skip(byteCount);
                    return;
                }
                long read = in.read(this.receiveBuffer, byteCount);
                if (read == -1L) {
                    throw new EOFException();
                }
                byteCount -= read;
                SpdyStream spdyStream2 = SpdyStream.this;
                synchronized (spdyStream2) {
                    boolean wasEmpty = this.readBuffer.size() == 0L;
                    this.readBuffer.writeAll((Source)this.receiveBuffer);
                    if (wasEmpty) {
                        SpdyStream.this.notifyAll();
                    }
                }
            }
        }

        public Timeout timeout() {
            return SpdyStream.this.readTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                this.closed = true;
                this.readBuffer.clear();
                SpdyStream.this.notifyAll();
            }
            SpdyStream.this.cancelStreamIfNecessary();
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("stream closed");
            }
            if (SpdyStream.this.errorCode != null) {
                throw new IOException("stream was reset: " + (Object)((Object)SpdyStream.this.errorCode));
            }
        }
    }
}

