/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.parsers;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class IntegerParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new IntegerParserFactory();
    private static final long serialVersionUID = 1L;

    private IntegerParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return new IValueParser(){

            @Override
            public boolean parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                char c;
                int i;
                int end = start + length;
                for (i = start; i < end && ((c = buffer[i]) == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f'); ++i) {
                }
                boolean negative = false;
                int limit = -2147483647;
                if (i < end) {
                    c = buffer[i];
                    if (c == '-') {
                        negative = true;
                        limit = Integer.MIN_VALUE;
                        ++i;
                    }
                    if (c == '+') {
                        ++i;
                    }
                }
                int result = 0;
                int multiplicationMin = limit / 10;
                boolean gotNumber = false;
                while (i < end && (c = buffer[i]) >= '0' && c <= '9') {
                    gotNumber = true;
                    if (result < multiplicationMin) {
                        return false;
                    }
                    int digit = c - 48;
                    if ((result *= 10) < limit + digit) {
                        return false;
                    }
                    result -= digit;
                    ++i;
                }
                while (i < end) {
                    c = buffer[i];
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != '\f') {
                        return false;
                    }
                    ++i;
                }
                if (!gotNumber) {
                    return false;
                }
                try {
                    out.writeInt(negative ? result : -result);
                    return true;
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

