/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.TransactionOptions;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.transaction.management.service.transaction.AtomicTransactionContext;
import org.apache.asterix.transaction.management.service.transaction.EntityLevelTransactionContext;

public class TransactionContextFactory {
    private TransactionContextFactory() {
    }

    public static ITransactionContext create(TxnId txnId, TransactionOptions options) {
        ITransactionManager.AtomicityLevel atomicityLevel = options.getAtomicityLevel();
        switch (atomicityLevel) {
            case ATOMIC: {
                return new AtomicTransactionContext(txnId);
            }
            case ENTITY_LEVEL: {
                return new EntityLevelTransactionContext(txnId);
            }
        }
        throw new IllegalStateException("Unknown transaction context type: " + atomicityLevel);
    }
}

