/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APolygonSerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class APolygonPartialBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    public static final APolygonPartialBinaryComparatorFactory INSTANCE = new APolygonPartialBinaryComparatorFactory();

    private APolygonPartialBinaryComparatorFactory() {
    }

    public IBinaryComparator createBinaryComparator() {
        return APolygonPartialBinaryComparatorFactory::compare;
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
        int pointCount1 = AInt16SerializerDeserializer.getShort(b1, s1 + APolygonSerializerDeserializer.getNumberOfPointsOffset());
        int c = Short.compare((short)pointCount1, AInt16SerializerDeserializer.getShort(b2, s2 + APolygonSerializerDeserializer.getNumberOfPointsOffset()));
        if (c == 0) {
            for (int i = 0; i < pointCount1; ++i) {
                int ci = Double.compare(DoublePointable.getDouble((byte[])b1, (int)(s1 + APolygonSerializerDeserializer.getCoordinateOffset(i, Coordinate.X))), DoublePointable.getDouble((byte[])b2, (int)(s1 + APolygonSerializerDeserializer.getCoordinateOffset(i, Coordinate.X))));
                if (ci == 0 && (ci = Double.compare(DoublePointable.getDouble((byte[])b1, (int)(s1 + APolygonSerializerDeserializer.getCoordinateOffset(i, Coordinate.Y))), DoublePointable.getDouble((byte[])b2, (int)(s1 + APolygonSerializerDeserializer.getCoordinateOffset(i, Coordinate.Y))))) == 0) continue;
                return ci;
            }
        }
        return c;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        return registry.getClassIdentifier(this.getClass(), 1L);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return INSTANCE;
    }
}

