/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.replication.api.IReplicationMessage;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.messaging.CheckpointPartitionIndexesTask;
import org.apache.asterix.replication.messaging.ComponentMaskTask;
import org.apache.asterix.replication.messaging.DeleteFileTask;
import org.apache.asterix.replication.messaging.DropIndexTask;
import org.apache.asterix.replication.messaging.MarkComponentValidTask;
import org.apache.asterix.replication.messaging.PartitionResourcesListResponse;
import org.apache.asterix.replication.messaging.PartitionResourcesListTask;
import org.apache.asterix.replication.messaging.ReplicateFileTask;
import org.apache.asterix.replication.messaging.ReplicateLogsTask;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.data.std.util.ExtendedByteArrayOutputStream;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.hyracks.util.StorageUtil;

public class ReplicationProtocol {
    public static final String LOG_REPLICATION_ACK = "$";
    public static final int INITIAL_BUFFER_SIZE = StorageUtil.getIntSizeInBytes((int)4, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE);
    private static final int REPLICATION_REQUEST_TYPE_SIZE = 4;
    private static final int REPLICATION_REQUEST_HEADER_SIZE = 8;
    private static final Map<Integer, ReplicationRequestType> TYPES = new HashMap<Integer, ReplicationRequestType>();

    public static ByteBuffer readRequest(ISocketChannel socketChannel, ByteBuffer dataBuffer) throws IOException {
        NetworkingUtil.readBytes(socketChannel, dataBuffer, 4);
        int requestSize = dataBuffer.getInt();
        ByteBuffer buf = ReplicationProtocol.ensureSize(dataBuffer, requestSize);
        NetworkingUtil.readBytes(socketChannel, buf, requestSize);
        return buf;
    }

    public static ReplicationRequestType getRequestType(ISocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
        NetworkingUtil.readBytes(socketChannel, byteBuffer, 4);
        return TYPES.get(byteBuffer.getInt());
    }

    private static ByteBuffer getGoodbyeBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(ReplicationRequestType.GOODBYE.ordinal());
        bb.flip();
        return bb;
    }

    public static int getTxnIdFromLogAckMessage(String msg) {
        return Integer.parseInt(msg.substring(msg.indexOf(LOG_REPLICATION_ACK) + 1));
    }

    public static void sendGoodbye(ISocketChannel socketChannel) throws IOException {
        ByteBuffer goodbyeBuffer = ReplicationProtocol.getGoodbyeBuffer();
        NetworkingUtil.transferBufferToChannel(socketChannel, goodbyeBuffer);
    }

    public static void sendAck(ISocketChannel socketChannel, ByteBuffer buf) {
        try {
            buf.clear();
            buf.putInt(ReplicationRequestType.ACK.ordinal());
            buf.flip();
            NetworkingUtil.transferBufferToChannel(socketChannel, buf);
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    public static void waitForAck(PartitionReplica replica) throws IOException {
        ByteBuffer buf;
        ISocketChannel channel = replica.getChannel();
        ReplicationRequestType responseFunction = ReplicationProtocol.getRequestType(channel, buf = replica.getReusableBuffer());
        if (responseFunction != ReplicationRequestType.ACK) {
            throw new IllegalStateException("Unexpected response while waiting for ack.");
        }
    }

    public static void sendTo(PartitionReplica replica, IReplicationMessage task) {
        ISocketChannel channel = replica.getChannel();
        ByteBuffer buf = replica.getReusableBuffer();
        ReplicationProtocol.sendTo(channel, task, buf);
    }

    public static void sendTo(ISocketChannel channel, IReplicationMessage task, ByteBuffer buf) {
        ExtendedByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream();
        try (DataOutputStream oos = new DataOutputStream((OutputStream)outputStream);){
            task.serialize(oos);
            int requestSize = 8 + oos.size();
            ByteBuffer requestBuffer = ReplicationProtocol.ensureSize(buf, requestSize);
            requestBuffer.putInt(task.getMessageType().ordinal());
            requestBuffer.putInt(oos.size());
            requestBuffer.put(outputStream.getByteArray(), 0, outputStream.getLength());
            requestBuffer.flip();
            NetworkingUtil.transferBufferToChannel(channel, requestBuffer);
            channel.getSocketChannel().socket().getOutputStream().flush();
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    public static IReplicationMessage read(ISocketChannel socketChannel, ByteBuffer buffer) throws IOException {
        ReplicationRequestType type = ReplicationProtocol.getRequestType(socketChannel, buffer);
        return ReplicationProtocol.readMessage(type, socketChannel, buffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IReplicationMessage readMessage(ReplicationRequestType type, ISocketChannel socketChannel, ByteBuffer buffer) {
        try {
            ByteBuffer requestBuf = ReplicationProtocol.readRequest(socketChannel, buffer);
            ByteArrayInputStream input = new ByteArrayInputStream(requestBuf.array(), requestBuf.position(), requestBuf.limit());
            try (DataInputStream dis = new DataInputStream(input);){
                switch (type) {
                    case PARTITION_RESOURCES_REQUEST: {
                        PartitionResourcesListTask partitionResourcesListTask = PartitionResourcesListTask.create(dis);
                        return partitionResourcesListTask;
                    }
                    case PARTITION_RESOURCES_RESPONSE: {
                        PartitionResourcesListResponse partitionResourcesListResponse = PartitionResourcesListResponse.create(dis);
                        return partitionResourcesListResponse;
                    }
                    case REPLICATE_RESOURCE_FILE: {
                        ReplicateFileTask replicateFileTask = ReplicateFileTask.create(dis);
                        return replicateFileTask;
                    }
                    case DELETE_RESOURCE_FILE: {
                        DeleteFileTask deleteFileTask = DeleteFileTask.create(dis);
                        return deleteFileTask;
                    }
                    case CHECKPOINT_PARTITION: {
                        CheckpointPartitionIndexesTask checkpointPartitionIndexesTask = CheckpointPartitionIndexesTask.create(dis);
                        return checkpointPartitionIndexesTask;
                    }
                    case LSM_COMPONENT_MASK: {
                        ComponentMaskTask componentMaskTask = ComponentMaskTask.create(dis);
                        return componentMaskTask;
                    }
                    case DROP_INDEX: {
                        DropIndexTask dropIndexTask = DropIndexTask.create(dis);
                        return dropIndexTask;
                    }
                    case MARK_COMPONENT_VALID: {
                        MarkComponentValidTask markComponentValidTask = MarkComponentValidTask.create(dis);
                        return markComponentValidTask;
                    }
                    case REPLICATE_LOGS: {
                        ReplicateLogsTask replicateLogsTask = ReplicateLogsTask.create(dis);
                        return replicateLogsTask;
                    }
                }
                throw new IllegalStateException("Unrecognized replication message");
            }
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    public static ByteBuffer getEndLogReplicationBuffer() {
        boolean logsBatchSize = true;
        ByteBuffer endLogRepBuffer = ByteBuffer.allocate(5);
        endLogRepBuffer.putInt(1);
        endLogRepBuffer.put((byte)0);
        endLogRepBuffer.flip();
        return endLogRepBuffer;
    }

    public static ISocketChannel establishReplicaConnection(INcApplicationContext appCtx, InetSocketAddress location) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        NetworkUtil.configure((SocketChannel)socketChannel);
        socketChannel.connect(location);
        socketChannel.configureBlocking(false);
        ISocketChannelFactory socketChannelFactory = appCtx.getServiceContext().getControllerService().getNetworkSecurityManager().getSocketChannelFactory();
        ISocketChannel clientChannel = socketChannelFactory.createClientChannel(socketChannel);
        if (clientChannel.requiresHandshake() && !clientChannel.handshake()) {
            throw new IllegalStateException("handshake failure");
        }
        socketChannel.configureBlocking(true);
        return clientChannel;
    }

    private static ByteBuffer ensureSize(ByteBuffer buffer, int size) {
        if (buffer == null || buffer.capacity() < size) {
            return ByteBuffer.allocate(size);
        }
        buffer.clear();
        return buffer;
    }

    static {
        Stream.of(ReplicationRequestType.values()).forEach(type -> TYPES.put(type.ordinal(), (ReplicationRequestType)((Object)type)));
    }

    public static enum ReplicationRequestType {
        GOODBYE,
        ACK,
        PARTITION_RESOURCES_REQUEST,
        PARTITION_RESOURCES_RESPONSE,
        REPLICATE_RESOURCE_FILE,
        DELETE_RESOURCE_FILE,
        CHECKPOINT_PARTITION,
        LSM_COMPONENT_MASK,
        MARK_COMPONENT_VALID,
        DROP_INDEX,
        REPLICATE_LOGS;

    }
}

