/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class SwitchInnerJoinBranchRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        InnerJoinOperator joinOperator = (InnerJoinOperator)op;
        Mutable leftRef = (Mutable)joinOperator.getInputs().get(0);
        Mutable rightRef = (Mutable)joinOperator.getInputs().get(1);
        ILogicalOperator left = (ILogicalOperator)leftRef.getValue();
        ILogicalOperator right = (ILogicalOperator)rightRef.getValue();
        boolean leftCardinalityOne = OperatorPropertiesUtil.isCardinalityZeroOrOne((ILogicalOperator)left);
        boolean rightCardinalityOne = OperatorPropertiesUtil.isCardinalityZeroOrOne((ILogicalOperator)right);
        if (!leftCardinalityOne || rightCardinalityOne) {
            return false;
        }
        leftRef.setValue((Object)right);
        rightRef.setValue((Object)left);
        return true;
    }
}

