/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursorInitialState;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.util.IndexCursorUtils;

public class LSMInvertedIndexDeletedKeysBTreeMergeCursor
extends LSMIndexSearchCursor {
    public LSMInvertedIndexDeletedKeysBTreeMergeCursor(ILSMIndexOperationContext opCtx, IIndexCursorStats stats) {
        super(opCtx, true, stats);
    }

    protected boolean isDeleted(LSMIndexSearchCursor.PriorityQueueElement checkElement) throws HyracksDataException {
        return false;
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMInvertedIndexRangeSearchCursorInitialState lsmInitialState = (LSMInvertedIndexRangeSearchCursorInitialState)initialState;
        this.cmp = lsmInitialState.getOriginalKeyComparator();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = null;
        int numBTrees = this.operationalComponents.size();
        this.rangeCursors = new IIndexCursor[numBTrees];
        MultiComparator keyCmp = lsmInitialState.getKeyComparator();
        RangePredicate btreePredicate = new RangePredicate(null, null, true, true, keyCmp, keyCmp);
        IIndexAccessor[] btreeAccessors = new IIndexAccessor[this.operationalComponents.size()];
        for (int i = 0; i < numBTrees; ++i) {
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            btreeAccessors[i] = component.getType() == ILSMComponent.LSMComponentType.MEMORY ? ((LSMInvertedIndexMemoryComponent)component).getBuddyIndex().createAccessor(this.iap) : ((LSMInvertedIndexDiskComponent)component).getBuddyIndex().createAccessor(this.iap);
            this.rangeCursors[i] = btreeAccessors[i].createSearchCursor(false);
        }
        IndexCursorUtils.open((IIndexAccessor[])btreeAccessors, (IIndexCursor[])this.rangeCursors, (ISearchPredicate)btreePredicate);
        try {
            this.setPriorityQueueComparator();
            this.initPriorityQueue();
        }
        catch (Throwable th) {
            IndexCursorUtils.close((IIndexCursor[])this.rangeCursors, (Throwable)th);
            throw HyracksDataException.create((Throwable)th);
        }
    }
}

