/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.client.result;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.channels.IInputChannelMonitor;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.IResultDirectory;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.IResultSetReader;
import org.apache.hyracks.api.result.ResultDirectoryRecord;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.client.net.ClientNetworkManager;
import org.apache.hyracks.comm.channels.IChannelConnectionFactory;
import org.apache.hyracks.comm.channels.ResultNetworkInputChannel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultSetReader
implements IResultSetReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int NUM_READ_BUFFERS = 1;
    private final IResultDirectory resultDirectory;
    private final ClientNetworkManager netManager;
    private final IHyracksCommonContext resultClientCtx;
    private final JobId jobId;
    private final ResultSetId resultSetId;
    private ResultDirectoryRecord[] knownRecords;
    private ResultInputChannelMonitor[] monitors;
    private ResultInputChannelMonitor currentRecordMonitor;
    private ResultNetworkInputChannel currentRecordChannel;
    private int currentRecord;

    public ResultSetReader(IResultDirectory resultDirectory, ClientNetworkManager netManager, IHyracksCommonContext resultClientCtx, JobId jobId, ResultSetId resultSetId) {
        this.resultDirectory = resultDirectory;
        this.netManager = netManager;
        this.resultClientCtx = resultClientCtx;
        this.jobId = jobId;
        this.resultSetId = resultSetId;
        this.currentRecord = -1;
    }

    public ResultJobRecord.Status getResultStatus() {
        try {
            return this.resultDirectory.getResultStatus(this.jobId, this.resultSetId);
        }
        catch (HyracksDataException e) {
            if (e.getErrorCode() != 24) {
                LOGGER.log(Level.WARN, "Exception retrieving result set for job " + this.jobId, (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Exception retrieving result set for job " + this.jobId, (Throwable)e);
        }
        return null;
    }

    public int read(IFrame frame) throws HyracksDataException {
        frame.reset();
        int readSize = 0;
        try {
            if (this.isFirstRead() && !this.hasNextRecord()) {
                return readSize;
            }
            while (readSize < frame.getFrameSize()) {
                if (this.currentRecordMonitor.hasMoreFrames()) {
                    ByteBuffer readBuffer = this.currentRecordChannel.getNextBuffer();
                    if (readBuffer == null) {
                        throw new IllegalStateException("Unexpected empty frame");
                    }
                    this.currentRecordMonitor.notifyFrameRead();
                    if (readSize == 0) {
                        int nBlocks = FrameHelper.deserializeNumOfMinFrame((ByteBuffer)readBuffer);
                        frame.ensureFrameSize(frame.getMinSize() * nBlocks);
                        frame.getBuffer().clear();
                    }
                    frame.getBuffer().put(readBuffer);
                    this.currentRecordChannel.recycleBuffer(readBuffer);
                    readSize = frame.getBuffer().position();
                    continue;
                }
                this.currentRecordChannel.close();
                if (this.currentRecordMonitor.failed()) {
                    throw HyracksDataException.create((int)93, (Serializable[])new Serializable[]{this.jobId});
                }
                if (!this.isLastRecord() && this.hasNextRecord()) continue;
            }
            frame.getBuffer().flip();
        }
        catch (Exception e) {
            if (this.isLocalFailure()) {
                this.currentRecordChannel.fail();
            }
            throw e;
        }
        return readSize;
    }

    public IResultMetadata getResultMetadata() {
        try {
            return this.resultDirectory.getResultMetadata(this.jobId, this.resultSetId);
        }
        catch (HyracksDataException e) {
            if (e.getErrorCode() != 24) {
                LOGGER.log(Level.WARN, "Exception retrieving result set for job " + this.jobId, (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Exception retrieving result set for job " + this.jobId, (Throwable)e);
        }
        return null;
    }

    private SocketAddress getSocketAddress(ResultDirectoryRecord record) throws HyracksDataException {
        try {
            NetworkAddress netAddr = record.getNetworkAddress();
            return new InetSocketAddress(InetAddress.getByAddress(netAddr.lookupIpAddress()), netAddr.getPort());
        }
        catch (UnknownHostException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private ResultInputChannelMonitor getMonitor(int partition) {
        if (this.knownRecords == null || this.knownRecords[partition] == null) {
            throw new IllegalStateException("Accessing monitors before obtaining the corresponding addresses");
        }
        if (this.monitors == null) {
            this.monitors = new ResultInputChannelMonitor[this.knownRecords.length];
        }
        if (this.monitors[partition] == null) {
            this.monitors[partition] = new ResultInputChannelMonitor();
        }
        return this.monitors[partition];
    }

    private boolean hasNextRecord() throws HyracksDataException {
        ++this.currentRecord;
        ResultDirectoryRecord record = this.getRecord(this.currentRecord);
        while (record.isEmpty() && ++this.currentRecord < this.knownRecords.length) {
            record = this.getRecord(this.currentRecord);
        }
        if (this.currentRecord == this.knownRecords.length) {
            return false;
        }
        this.requestRecordData(record);
        return true;
    }

    private ResultDirectoryRecord getRecord(int recordNum) throws HyracksDataException {
        try {
            while (this.knownRecords == null || this.knownRecords[recordNum] == null) {
                this.knownRecords = this.resultDirectory.getResultLocations(this.jobId, this.resultSetId, this.knownRecords);
            }
            return this.knownRecords[recordNum];
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void requestRecordData(ResultDirectoryRecord record) throws HyracksDataException {
        this.currentRecordChannel = new ResultNetworkInputChannel((IChannelConnectionFactory)this.netManager, this.getSocketAddress(record), this.jobId, this.resultSetId, this.currentRecord, 1);
        this.currentRecordMonitor = this.getMonitor(this.currentRecord);
        this.currentRecordChannel.registerMonitor((IInputChannelMonitor)this.currentRecordMonitor);
        this.currentRecordChannel.open(this.resultClientCtx);
    }

    private boolean isFirstRead() {
        return this.currentRecord == -1;
    }

    private boolean isLastRecord() {
        return this.knownRecords != null && this.currentRecord == this.knownRecords.length - 1;
    }

    private boolean isLocalFailure() {
        return this.currentRecordMonitor != null && !this.currentRecordMonitor.failed();
    }

    private static class ResultInputChannelMonitor
    implements IInputChannelMonitor {
        private int availableFrames;
        private boolean eos = false;
        private boolean failed = false;

        ResultInputChannelMonitor() {
        }

        public synchronized void notifyFailure(IInputChannel channel, int errorCode) {
            this.failed = true;
            this.notifyAll();
        }

        public synchronized void notifyDataAvailability(IInputChannel channel, int nFrames) {
            this.availableFrames += nFrames;
            this.notifyAll();
        }

        public synchronized void notifyEndOfStream(IInputChannel channel) {
            this.eos = true;
            this.notifyAll();
        }

        synchronized boolean failed() {
            return this.failed;
        }

        synchronized void notifyFrameRead() {
            --this.availableFrames;
            this.notifyAll();
        }

        synchronized boolean hasMoreFrames() throws HyracksDataException {
            while (!this.failed && !this.eos && this.availableFrames == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw HyracksDataException.create((Throwable)e);
                }
            }
            return !this.failed && !this.isFullyConsumed();
        }

        private synchronized boolean isFullyConsumed() {
            return this.availableFrames == 0 && this.eos;
        }
    }
}

