/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.rss;

import com.rometools.rome.feed.synd.SyndEntry;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.rss.RSSRecordReader;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class RSSRecordReaderFactory
implements IRecordReaderFactory<SyndEntry> {
    private static final long serialVersionUID = 1L;
    private final List<String> urls = new ArrayList<String>();
    private transient AlgebricksAbsolutePartitionConstraint clusterLocations;
    private transient IServiceContext serviceContext;
    private static final List<String> recordReaderNames = Collections.unmodifiableList(Arrays.asList("rss_feed"));

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        int count = this.urls.size();
        this.clusterLocations = IExternalDataSourceFactory.getPartitionConstraints((ICcApplicationContext)this.serviceContext.getApplicationContext(), this.clusterLocations, count);
        return this.clusterLocations;
    }

    @Override
    public void configure(IServiceContext serviceContext, Map<String, String> configuration, IWarningCollector warningCollector) {
        this.serviceContext = serviceContext;
        String url = configuration.get("url");
        if (url == null) {
            throw new IllegalArgumentException("no RSS URL provided");
        }
        this.initializeURLs(url);
    }

    private void initializeURLs(String url) {
        String[] rssURLs;
        this.urls.clear();
        for (String rssURL : rssURLs = url.split(",")) {
            this.urls.add(rssURL);
        }
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    @Override
    public IRecordReader<? extends SyndEntry> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            return new RSSRecordReader(this.urls.get(partition));
        }
        catch (MalformedURLException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public Class<? extends SyndEntry> getRecordClass() {
        return SyndEntry.class;
    }
}

