/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.collectors;

import java.util.LinkedList;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.collectors.IPartitionBatchManager;

public class SequentialMergeFrameReader
implements IFrameReader {
    private final int numSenders;
    private final IPartitionBatchManager partitionBatchManager;
    private final LinkedList<IFrameReader> senders;
    private boolean isOpen;

    public SequentialMergeFrameReader(int numSenders, IPartitionBatchManager partitionBatchManager) {
        this.numSenders = numSenders;
        this.partitionBatchManager = partitionBatchManager;
        this.senders = new LinkedList();
        this.isOpen = false;
    }

    public void open() throws HyracksDataException {
        if (!this.isOpen) {
            this.isOpen = true;
            this.partitionBatchManager.getNextBatch(this.senders, this.numSenders);
            for (IFrameReader sender : this.senders) {
                sender.open();
            }
        }
    }

    public boolean nextFrame(IFrame outFrame) throws HyracksDataException {
        while (!this.senders.isEmpty()) {
            IFrameReader currentSender = this.senders.getFirst();
            outFrame.reset();
            if (currentSender.nextFrame(outFrame)) {
                return true;
            }
            currentSender.close();
            this.senders.removeFirst();
        }
        return false;
    }

    public void close() throws HyracksDataException {
        for (IFrameReader sender : this.senders) {
            sender.close();
        }
    }
}

