/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIESOR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.tx.control.jdbc.xa.impl;

import static org.osgi.service.transaction.control.jdbc.JDBCConnectionProviderFactory.LOCAL_ENLISTMENT_ENABLED;
import static org.osgi.service.transaction.control.jdbc.JDBCConnectionProviderFactory.XA_ENLISTMENT_ENABLED;

import java.util.Dictionary;
import java.util.Hashtable;

import org.apache.aries.tx.control.jdbc.common.impl.AbstractJDBCConnectionProvider;
import org.apache.aries.tx.control.jdbc.common.impl.ResourceTrackingJDBCConnectionProviderFactory;
import org.apache.aries.tx.control.resource.common.impl.ConfigurationDefinedResourceFactory;
import org.apache.aries.tx.control.resource.common.impl.ResourceActivator;
import org.apache.aries.tx.control.resource.common.impl.ResourceProviderFactoryServiceFactory;
import org.apache.aries.tx.control.resource.common.impl.TrackingResourceProviderFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.transaction.control.jdbc.JDBCConnectionProviderFactory;

public class Activator extends ResourceActivator<AbstractJDBCConnectionProvider, ResourceTrackingJDBCConnectionProviderFactory> {

	
	@Override
	protected ResourceProviderFactoryServiceFactory<AbstractJDBCConnectionProvider, ResourceTrackingJDBCConnectionProviderFactory> getServiceFactory(
			BundleContext context) {
		return new ResourceProviderFactoryServiceFactory<AbstractJDBCConnectionProvider, ResourceTrackingJDBCConnectionProviderFactory>() {
			@Override
			protected TrackingResourceProviderFactory<AbstractJDBCConnectionProvider> getTrackingResourceManagerProviderFactory() {
				return new ResourceTrackingJDBCConnectionProviderFactory(
						new JDBCConnectionProviderFactoryImpl(context));
			}
		};
	}

	@Override
	protected Class<? super ResourceTrackingJDBCConnectionProviderFactory> getAdvertisedInterface() {
		return JDBCConnectionProviderFactory.class;
	}

	@Override
	protected Dictionary<String, Object> getServiceProperties() {
		Dictionary<String, Object> props = new Hashtable<>();
		props.put(LOCAL_ENLISTMENT_ENABLED, Boolean.TRUE);
		props.put(XA_ENLISTMENT_ENABLED, Boolean.TRUE);
		props.put("osgi.recovery.enabled", Boolean.TRUE);
		return props;
	}

	@Override
	protected ConfigurationDefinedResourceFactory getConfigurationDefinedResourceFactory(BundleContext context) {
		return new ManagedServiceFactoryImpl(context);
	}

	@Override
	protected String getMSFPid() {
		return "org.apache.aries.tx.control.jdbc.xa";
	}
}
