/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.shiro.authc.impl;

import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.aries.jax.rs.shiro.authc.impl.SecurityManagerAssociatingFilter;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.web.jaxrs.ExceptionMapper;
import org.apache.shiro.web.jaxrs.SubjectPrincipalRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroAuthenticationFeature
implements Feature {
    private static final Logger _LOG = LoggerFactory.getLogger(ShiroAuthenticationFeature.class);
    public static final String SESSION_COOKIE_NAME = "JAXRSSESSIONID";
    private final List<Realm> realms;
    private final DefaultSecurityManager manager;

    public ShiroAuthenticationFeature(List<Realm> realms) {
        this.realms = realms;
        this.manager = realms.isEmpty() ? new DefaultSecurityManager() : new DefaultSecurityManager(realms);
    }

    public boolean configure(FeatureContext fc) {
        Configuration configuration = fc.getConfiguration();
        if (_LOG.isInfoEnabled()) {
            Map applicationProps = (Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties");
            _LOG.info("Registering the Shiro Authentication feature with application {}", (Object)applicationProps.getOrDefault("osgi.jaxrs.name", "<No Name found in application configuration>"));
        }
        if (this.realms.isEmpty()) {
            _LOG.warn("There are no authentication realms available. Users may not be able to authenticate.");
        } else {
            _LOG.debug("Using the authentication realms {}.", this.realms);
        }
        _LOG.debug("Registering the Shiro SecurityManagerAssociatingFilter");
        fc.register((Object)new SecurityManagerAssociatingFilter((SecurityManager)this.manager), 1000);
        Map contracts = configuration.getContracts(ExceptionMapper.class);
        if (contracts.isEmpty()) {
            _LOG.debug("Registering the Shiro ExceptionMapper");
            fc.register(ExceptionMapper.class, 1000);
        } else if (1000 < contracts.getOrDefault(javax.ws.rs.ext.ExceptionMapper.class, 5000)) {
            _LOG.debug("Updating the priority of the Shiro ExceptionMapper from {} to {}", (Object)contracts.getOrDefault(javax.ws.rs.ext.ExceptionMapper.class, 5000), (Object)2000);
            contracts.put(javax.ws.rs.ext.ExceptionMapper.class, 1000);
        }
        contracts = configuration.getContracts(SubjectPrincipalRequestFilter.class);
        if (contracts.isEmpty()) {
            _LOG.debug("Registering the Shiro SubjectPrincipalRequestFilter");
            fc.register(SubjectPrincipalRequestFilter.class, 1001);
        } else if (1000 < contracts.getOrDefault(ContainerRequestFilter.class, 5000)) {
            _LOG.debug("Updating the priority of the Shiro SubjectPrincipalRequestFilter from {} to {}", (Object)contracts.getOrDefault(ContainerRequestFilter.class, 5000), (Object)1001);
            contracts.put(ContainerRequestFilter.class, 1001);
        }
        return true;
    }

    public void close() {
        this.manager.destroy();
    }
}

